/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.Counts;
import software.amazon.awssdk.services.inspector2.model.CountsListCopier;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCoverageStatisticsResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, ListCoverageStatisticsResponse> {
    private static final SdkField<List<Counts>> COUNTS_BY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("countsByGroup").getter(ListCoverageStatisticsResponse.getter(ListCoverageStatisticsResponse::countsByGroup)).setter(ListCoverageStatisticsResponse.setter(Builder::countsByGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countsByGroup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Counts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCoverageStatisticsResponse.getter(ListCoverageStatisticsResponse::nextToken)).setter(ListCoverageStatisticsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Long> TOTAL_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalCounts").getter(ListCoverageStatisticsResponse.getter(ListCoverageStatisticsResponse::totalCounts)).setter(ListCoverageStatisticsResponse.setter(Builder::totalCounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTS_BY_GROUP_FIELD, NEXT_TOKEN_FIELD, TOTAL_COUNTS_FIELD));
    private final List<Counts> countsByGroup;
    private final String nextToken;
    private final Long totalCounts;

    private ListCoverageStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.countsByGroup = builder.countsByGroup;
        this.nextToken = builder.nextToken;
        this.totalCounts = builder.totalCounts;
    }

    public final boolean hasCountsByGroup() {
        return this.countsByGroup != null && !(this.countsByGroup instanceof SdkAutoConstructList);
    }

    public final List<Counts> countsByGroup() {
        return this.countsByGroup;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long totalCounts() {
        return this.totalCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCountsByGroup() ? this.countsByGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoverageStatisticsResponse)) {
            return false;
        }
        ListCoverageStatisticsResponse other = (ListCoverageStatisticsResponse)((Object)obj);
        return this.hasCountsByGroup() == other.hasCountsByGroup() && Objects.equals(this.countsByGroup(), other.countsByGroup()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCounts(), other.totalCounts());
    }

    public final String toString() {
        return ToString.builder((String)"ListCoverageStatisticsResponse").add("CountsByGroup", this.hasCountsByGroup() ? this.countsByGroup() : null).add("NextToken", (Object)this.nextToken()).add("TotalCounts", (Object)this.totalCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "countsByGroup": {
                return Optional.ofNullable(clazz.cast(this.countsByGroup()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "totalCounts": {
                return Optional.ofNullable(clazz.cast(this.totalCounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCoverageStatisticsResponse, T> g) {
        return obj -> g.apply((ListCoverageStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<Counts> countsByGroup = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long totalCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoverageStatisticsResponse model) {
            super(model);
            this.countsByGroup(model.countsByGroup);
            this.nextToken(model.nextToken);
            this.totalCounts(model.totalCounts);
        }

        public final List<Counts.Builder> getCountsByGroup() {
            List<Counts.Builder> result = CountsListCopier.copyToBuilder(this.countsByGroup);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCountsByGroup(Collection<Counts.BuilderImpl> countsByGroup) {
            this.countsByGroup = CountsListCopier.copyFromBuilder(countsByGroup);
        }

        @Override
        public final Builder countsByGroup(Collection<Counts> countsByGroup) {
            this.countsByGroup = CountsListCopier.copy(countsByGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countsByGroup(Counts ... countsByGroup) {
            this.countsByGroup(Arrays.asList(countsByGroup));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countsByGroup(Consumer<Counts.Builder> ... countsByGroup) {
            this.countsByGroup(Stream.of(countsByGroup).map(c -> (Counts)((Counts.Builder)Counts.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getTotalCounts() {
            return this.totalCounts;
        }

        public final void setTotalCounts(Long totalCounts) {
            this.totalCounts = totalCounts;
        }

        @Override
        public final Builder totalCounts(Long totalCounts) {
            this.totalCounts = totalCounts;
            return this;
        }

        @Override
        public ListCoverageStatisticsResponse build() {
            return new ListCoverageStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCoverageStatisticsResponse> {
        public Builder countsByGroup(Collection<Counts> var1);

        public Builder countsByGroup(Counts ... var1);

        public Builder countsByGroup(Consumer<Counts.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder totalCounts(Long var1);
    }
}

