/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NoSuchEntityErrorCode {
    ASSESSMENT_TARGET_DOES_NOT_EXIST("ASSESSMENT_TARGET_DOES_NOT_EXIST"),
    ASSESSMENT_TEMPLATE_DOES_NOT_EXIST("ASSESSMENT_TEMPLATE_DOES_NOT_EXIST"),
    ASSESSMENT_RUN_DOES_NOT_EXIST("ASSESSMENT_RUN_DOES_NOT_EXIST"),
    FINDING_DOES_NOT_EXIST("FINDING_DOES_NOT_EXIST"),
    RESOURCE_GROUP_DOES_NOT_EXIST("RESOURCE_GROUP_DOES_NOT_EXIST"),
    RULES_PACKAGE_DOES_NOT_EXIST("RULES_PACKAGE_DOES_NOT_EXIST"),
    SNS_TOPIC_DOES_NOT_EXIST("SNS_TOPIC_DOES_NOT_EXIST"),
    IAM_ROLE_DOES_NOT_EXIST("IAM_ROLE_DOES_NOT_EXIST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NoSuchEntityErrorCode> VALUE_MAP;
    private final String value;

    private NoSuchEntityErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NoSuchEntityErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NoSuchEntityErrorCode> knownValues() {
        EnumSet<NoSuchEntityErrorCode> knownValues = EnumSet.allOf(NoSuchEntityErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NoSuchEntityErrorCode.class, NoSuchEntityErrorCode::toString);
    }
}

