/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum NoSuchEntityErrorCode {
    ASSESSMENT_TARGET_DOES_NOT_EXIST("ASSESSMENT_TARGET_DOES_NOT_EXIST"),

    ASSESSMENT_TEMPLATE_DOES_NOT_EXIST("ASSESSMENT_TEMPLATE_DOES_NOT_EXIST"),

    ASSESSMENT_RUN_DOES_NOT_EXIST("ASSESSMENT_RUN_DOES_NOT_EXIST"),

    FINDING_DOES_NOT_EXIST("FINDING_DOES_NOT_EXIST"),

    RESOURCE_GROUP_DOES_NOT_EXIST("RESOURCE_GROUP_DOES_NOT_EXIST"),

    RULES_PACKAGE_DOES_NOT_EXIST("RULES_PACKAGE_DOES_NOT_EXIST"),

    SNS_TOPIC_DOES_NOT_EXIST("SNS_TOPIC_DOES_NOT_EXIST"),

    IAM_ROLE_DOES_NOT_EXIST("IAM_ROLE_DOES_NOT_EXIST"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NoSuchEntityErrorCode> VALUE_MAP = EnumUtils.uniqueIndex(NoSuchEntityErrorCode.class,
            NoSuchEntityErrorCode::toString);

    private final String value;

    private NoSuchEntityErrorCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return NoSuchEntityErrorCode corresponding to the value
     */
    public static NoSuchEntityErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link NoSuchEntityErrorCode}s
     */
    public static Set<NoSuchEntityErrorCode> knownValues() {
        Set<NoSuchEntityErrorCode> knownValues = EnumSet.allOf(NoSuchEntityErrorCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
