/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorAsyncClient;
import software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest;
import software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse;

public class ListEventSubscriptionsPublisher
implements SdkPublisher<ListEventSubscriptionsResponse> {
    private final InspectorAsyncClient client;
    private final ListEventSubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventSubscriptionsPublisher(InspectorAsyncClient client, ListEventSubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventSubscriptionsPublisher(InspectorAsyncClient client, ListEventSubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventSubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventSubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListEventSubscriptionsResponseFetcher
    implements AsyncPageFetcher<ListEventSubscriptionsResponse> {
        private ListEventSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventSubscriptionsResponse> nextPage(ListEventSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListEventSubscriptionsPublisher.this.client.listEventSubscriptions(ListEventSubscriptionsPublisher.this.firstRequest);
            }
            return ListEventSubscriptionsPublisher.this.client.listEventSubscriptions((ListEventSubscriptionsRequest)((Object)ListEventSubscriptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

