/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InspectorEvent {
    ASSESSMENT_RUN_STARTED("ASSESSMENT_RUN_STARTED"),
    ASSESSMENT_RUN_COMPLETED("ASSESSMENT_RUN_COMPLETED"),
    ASSESSMENT_RUN_STATE_CHANGED("ASSESSMENT_RUN_STATE_CHANGED"),
    FINDING_REPORTED("FINDING_REPORTED"),
    OTHER("OTHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InspectorEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InspectorEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InspectorEvent.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InspectorEvent> knownValues() {
        return Stream.of(InspectorEvent.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

