/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AgentIdListCopier;
import software.amazon.awssdk.services.inspector.model.Attribute;
import software.amazon.awssdk.services.inspector.model.AttributeListCopier;
import software.amazon.awssdk.services.inspector.model.AutoScalingGroupListCopier;
import software.amazon.awssdk.services.inspector.model.FilterRulesPackageArnListCopier;
import software.amazon.awssdk.services.inspector.model.RuleNameListCopier;
import software.amazon.awssdk.services.inspector.model.Severity;
import software.amazon.awssdk.services.inspector.model.SeverityListCopier;
import software.amazon.awssdk.services.inspector.model.TimestampRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingFilter> {
    private static final SdkField<List<String>> AGENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("agentIds").getter(FindingFilter.getter(FindingFilter::agentIds)).setter(FindingFilter.setter(Builder::agentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTO_SCALING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoScalingGroups").getter(FindingFilter.getter(FindingFilter::autoScalingGroups)).setter(FindingFilter.setter(Builder::autoScalingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RULE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ruleNames").getter(FindingFilter.getter(FindingFilter::ruleNames)).setter(FindingFilter.setter(Builder::ruleNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SEVERITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("severities").getter(FindingFilter.getter(FindingFilter::severitiesAsStrings)).setter(FindingFilter.setter(Builder::severitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rulesPackageArns").getter(FindingFilter.getter(FindingFilter::rulesPackageArns)).setter(FindingFilter.setter(Builder::rulesPackageArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(FindingFilter.getter(FindingFilter::attributes)).setter(FindingFilter.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attribute>> USER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userAttributes").getter(FindingFilter.getter(FindingFilter::userAttributes)).setter(FindingFilter.setter(Builder::userAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimestampRange> CREATION_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("creationTimeRange").getter(FindingFilter.getter(FindingFilter::creationTimeRange)).setter(FindingFilter.setter(Builder::creationTimeRange)).constructor(TimestampRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimeRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_IDS_FIELD, AUTO_SCALING_GROUPS_FIELD, RULE_NAMES_FIELD, SEVERITIES_FIELD, RULES_PACKAGE_ARNS_FIELD, ATTRIBUTES_FIELD, USER_ATTRIBUTES_FIELD, CREATION_TIME_RANGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> agentIds;
    private final List<String> autoScalingGroups;
    private final List<String> ruleNames;
    private final List<String> severities;
    private final List<String> rulesPackageArns;
    private final List<Attribute> attributes;
    private final List<Attribute> userAttributes;
    private final TimestampRange creationTimeRange;

    private FindingFilter(BuilderImpl builder) {
        this.agentIds = builder.agentIds;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.ruleNames = builder.ruleNames;
        this.severities = builder.severities;
        this.rulesPackageArns = builder.rulesPackageArns;
        this.attributes = builder.attributes;
        this.userAttributes = builder.userAttributes;
        this.creationTimeRange = builder.creationTimeRange;
    }

    public final boolean hasAgentIds() {
        return this.agentIds != null && !(this.agentIds instanceof SdkAutoConstructList);
    }

    public final List<String> agentIds() {
        return this.agentIds;
    }

    public final boolean hasAutoScalingGroups() {
        return this.autoScalingGroups != null && !(this.autoScalingGroups instanceof SdkAutoConstructList);
    }

    public final List<String> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public final boolean hasRuleNames() {
        return this.ruleNames != null && !(this.ruleNames instanceof SdkAutoConstructList);
    }

    public final List<String> ruleNames() {
        return this.ruleNames;
    }

    public final List<Severity> severities() {
        return SeverityListCopier.copyStringToEnum(this.severities);
    }

    public final boolean hasSeverities() {
        return this.severities != null && !(this.severities instanceof SdkAutoConstructList);
    }

    public final List<String> severitiesAsStrings() {
        return this.severities;
    }

    public final boolean hasRulesPackageArns() {
        return this.rulesPackageArns != null && !(this.rulesPackageArns instanceof SdkAutoConstructList);
    }

    public final List<String> rulesPackageArns() {
        return this.rulesPackageArns;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<Attribute> attributes() {
        return this.attributes;
    }

    public final boolean hasUserAttributes() {
        return this.userAttributes != null && !(this.userAttributes instanceof SdkAutoConstructList);
    }

    public final List<Attribute> userAttributes() {
        return this.userAttributes;
    }

    public final TimestampRange creationTimeRange() {
        return this.creationTimeRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentIds() ? this.agentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoScalingGroups() ? this.autoScalingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleNames() ? this.ruleNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSeverities() ? this.severitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRulesPackageArns() ? this.rulesPackageArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAttributes() ? this.userAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingFilter)) {
            return false;
        }
        FindingFilter other = (FindingFilter)obj;
        return this.hasAgentIds() == other.hasAgentIds() && Objects.equals(this.agentIds(), other.agentIds()) && this.hasAutoScalingGroups() == other.hasAutoScalingGroups() && Objects.equals(this.autoScalingGroups(), other.autoScalingGroups()) && this.hasRuleNames() == other.hasRuleNames() && Objects.equals(this.ruleNames(), other.ruleNames()) && this.hasSeverities() == other.hasSeverities() && Objects.equals(this.severitiesAsStrings(), other.severitiesAsStrings()) && this.hasRulesPackageArns() == other.hasRulesPackageArns() && Objects.equals(this.rulesPackageArns(), other.rulesPackageArns()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasUserAttributes() == other.hasUserAttributes() && Objects.equals(this.userAttributes(), other.userAttributes()) && Objects.equals(this.creationTimeRange(), other.creationTimeRange());
    }

    public final String toString() {
        return ToString.builder((String)"FindingFilter").add("AgentIds", this.hasAgentIds() ? this.agentIds() : null).add("AutoScalingGroups", this.hasAutoScalingGroups() ? this.autoScalingGroups() : null).add("RuleNames", this.hasRuleNames() ? this.ruleNames() : null).add("Severities", this.hasSeverities() ? this.severitiesAsStrings() : null).add("RulesPackageArns", this.hasRulesPackageArns() ? this.rulesPackageArns() : null).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("UserAttributes", this.hasUserAttributes() ? this.userAttributes() : null).add("CreationTimeRange", (Object)this.creationTimeRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentIds": {
                return Optional.ofNullable(clazz.cast(this.agentIds()));
            }
            case "autoScalingGroups": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroups()));
            }
            case "ruleNames": {
                return Optional.ofNullable(clazz.cast(this.ruleNames()));
            }
            case "severities": {
                return Optional.ofNullable(clazz.cast(this.severitiesAsStrings()));
            }
            case "rulesPackageArns": {
                return Optional.ofNullable(clazz.cast(this.rulesPackageArns()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "userAttributes": {
                return Optional.ofNullable(clazz.cast(this.userAttributes()));
            }
            case "creationTimeRange": {
                return Optional.ofNullable(clazz.cast(this.creationTimeRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingFilter, T> g) {
        return obj -> g.apply((FindingFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> agentIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> ruleNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> severities = DefaultSdkAutoConstructList.getInstance();
        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();
        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private List<Attribute> userAttributes = DefaultSdkAutoConstructList.getInstance();
        private TimestampRange creationTimeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingFilter model) {
            this.agentIds(model.agentIds);
            this.autoScalingGroups(model.autoScalingGroups);
            this.ruleNames(model.ruleNames);
            this.severitiesWithStrings(model.severities);
            this.rulesPackageArns(model.rulesPackageArns);
            this.attributes(model.attributes);
            this.userAttributes(model.userAttributes);
            this.creationTimeRange(model.creationTimeRange);
        }

        public final Collection<String> getAgentIds() {
            if (this.agentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentIds;
        }

        @Override
        public final Builder agentIds(Collection<String> agentIds) {
            this.agentIds = AgentIdListCopier.copy(agentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentIds(String ... agentIds) {
            this.agentIds(Arrays.asList(agentIds));
            return this;
        }

        public final void setAgentIds(Collection<String> agentIds) {
            this.agentIds = AgentIdListCopier.copy(agentIds);
        }

        public final Collection<String> getAutoScalingGroups() {
            if (this.autoScalingGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
        }

        public final Collection<String> getRuleNames() {
            if (this.ruleNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleNames;
        }

        @Override
        public final Builder ruleNames(Collection<String> ruleNames) {
            this.ruleNames = RuleNameListCopier.copy(ruleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleNames(String ... ruleNames) {
            this.ruleNames(Arrays.asList(ruleNames));
            return this;
        }

        public final void setRuleNames(Collection<String> ruleNames) {
            this.ruleNames = RuleNameListCopier.copy(ruleNames);
        }

        public final Collection<String> getSeverities() {
            if (this.severities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.severities;
        }

        @Override
        public final Builder severitiesWithStrings(Collection<String> severities) {
            this.severities = SeverityListCopier.copy(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severitiesWithStrings(String ... severities) {
            this.severitiesWithStrings(Arrays.asList(severities));
            return this;
        }

        @Override
        public final Builder severities(Collection<Severity> severities) {
            this.severities = SeverityListCopier.copyEnumToString(severities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severities(Severity ... severities) {
            this.severities(Arrays.asList(severities));
            return this;
        }

        public final void setSeverities(Collection<String> severities) {
            this.severities = SeverityListCopier.copy(severities);
        }

        public final Collection<String> getRulesPackageArns() {
            if (this.rulesPackageArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rulesPackageArns;
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = FilterRulesPackageArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String ... rulesPackageArns) {
            this.rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = FilterRulesPackageArnListCopier.copy(rulesPackageArns);
        }

        public final List<Attribute.Builder> getAttributes() {
            List<Attribute.Builder> result = AttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributeListCopier.copyFromBuilder(attributes);
        }

        public final List<Attribute.Builder> getUserAttributes() {
            List<Attribute.Builder> result = AttributeListCopier.copyToBuilder(this.userAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder userAttributes(Collection<Attribute> userAttributes) {
            this.userAttributes = AttributeListCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Attribute ... userAttributes) {
            this.userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<Attribute.Builder> ... userAttributes) {
            this.userAttributes(Stream.of(userAttributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<Attribute.BuilderImpl> userAttributes) {
            this.userAttributes = AttributeListCopier.copyFromBuilder(userAttributes);
        }

        public final TimestampRange.Builder getCreationTimeRange() {
            return this.creationTimeRange != null ? this.creationTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder creationTimeRange(TimestampRange creationTimeRange) {
            this.creationTimeRange = creationTimeRange;
            return this;
        }

        public final void setCreationTimeRange(TimestampRange.BuilderImpl creationTimeRange) {
            this.creationTimeRange = creationTimeRange != null ? creationTimeRange.build() : null;
        }

        public FindingFilter build() {
            return new FindingFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingFilter> {
        public Builder agentIds(Collection<String> var1);

        public Builder agentIds(String ... var1);

        public Builder autoScalingGroups(Collection<String> var1);

        public Builder autoScalingGroups(String ... var1);

        public Builder ruleNames(Collection<String> var1);

        public Builder ruleNames(String ... var1);

        public Builder severitiesWithStrings(Collection<String> var1);

        public Builder severitiesWithStrings(String ... var1);

        public Builder severities(Collection<Severity> var1);

        public Builder severities(Severity ... var1);

        public Builder rulesPackageArns(Collection<String> var1);

        public Builder rulesPackageArns(String ... var1);

        public Builder attributes(Collection<Attribute> var1);

        public Builder attributes(Attribute ... var1);

        public Builder attributes(Consumer<Attribute.Builder> ... var1);

        public Builder userAttributes(Collection<Attribute> var1);

        public Builder userAttributes(Attribute ... var1);

        public Builder userAttributes(Consumer<Attribute.Builder> ... var1);

        public Builder creationTimeRange(TimestampRange var1);

        default public Builder creationTimeRange(Consumer<TimestampRange.Builder> creationTimeRange) {
            return this.creationTimeRange((TimestampRange)((TimestampRange.Builder)TimestampRange.builder().applyMutation(creationTimeRange)).build());
        }
    }
}

