/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AgentHealthCode {
    IDLE("IDLE"),
    RUNNING("RUNNING"),
    SHUTDOWN("SHUTDOWN"),
    UNHEALTHY("UNHEALTHY"),
    THROTTLED("THROTTLED"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AgentHealthCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AgentHealthCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AgentHealthCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AgentHealthCode> knownValues() {
        return Stream.of(AgentHealthCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

