/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AssessmentRunState {
    CREATED("CREATED"),
    START_DATA_COLLECTION_PENDING("START_DATA_COLLECTION_PENDING"),
    START_DATA_COLLECTION_IN_PROGRESS("START_DATA_COLLECTION_IN_PROGRESS"),
    COLLECTING_DATA("COLLECTING_DATA"),
    STOP_DATA_COLLECTION_PENDING("STOP_DATA_COLLECTION_PENDING"),
    DATA_COLLECTED("DATA_COLLECTED"),
    START_EVALUATING_RULES_PENDING("START_EVALUATING_RULES_PENDING"),
    EVALUATING_RULES("EVALUATING_RULES"),
    FAILED("FAILED"),
    ERROR("ERROR"),
    COMPLETED("COMPLETED"),
    COMPLETED_WITH_ERRORS("COMPLETED_WITH_ERRORS"),
    CANCELED("CANCELED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AssessmentRunState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssessmentRunState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AssessmentRunState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssessmentRunState> knownValues() {
        return Stream.of(AssessmentRunState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

