/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFindingsResponse extends InspectorResponse implements
        ToCopyableBuilder<DescribeFindingsResponse.Builder, DescribeFindingsResponse> {
    private static final SdkField<List<Finding>> FINDINGS_FIELD = SdkField
            .<List<Finding>> builder(MarshallingType.LIST)
            .memberName("findings")
            .getter(getter(DescribeFindingsResponse::findings))
            .setter(setter(Builder::findings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Finding> builder(MarshallingType.SDK_POJO)
                                            .constructor(Finding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField
            .<Map<String, FailedItemDetails>> builder(MarshallingType.MAP)
            .memberName("failedItems")
            .getter(getter(DescribeFindingsResponse::failedItems))
            .setter(setter(Builder::failedItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FailedItemDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedItemDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_FIELD,
            FAILED_ITEMS_FIELD));

    private final List<Finding> findings;

    private final Map<String, FailedItemDetails> failedItems;

    private DescribeFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.findings = builder.findings;
        this.failedItems = builder.failedItems;
    }

    /**
     * Returns true if the Findings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFindings() {
        return findings != null && !(findings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the finding.
     */
    public final List<Finding> findings() {
        return findings;
    }

    /**
     * Returns true if the FailedItems property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFailedItems() {
        return failedItems != null && !(failedItems instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Finding details that cannot be described. An error code is provided for each failed item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Finding details that cannot be described. An error code is provided for each failed item.
     */
    public final Map<String, FailedItemDetails> failedItems() {
        return failedItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFindings() ? findings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedItems() ? failedItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFindingsResponse)) {
            return false;
        }
        DescribeFindingsResponse other = (DescribeFindingsResponse) obj;
        return hasFindings() == other.hasFindings() && Objects.equals(findings(), other.findings())
                && hasFailedItems() == other.hasFailedItems() && Objects.equals(failedItems(), other.failedItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFindingsResponse").add("Findings", hasFindings() ? findings() : null)
                .add("FailedItems", hasFailedItems() ? failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findings":
            return Optional.ofNullable(clazz.cast(findings()));
        case "failedItems":
            return Optional.ofNullable(clazz.cast(failedItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFindingsResponse, T> g) {
        return obj -> g.apply((DescribeFindingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFindingsResponse> {
        /**
         * <p>
         * Information about the finding.
         * </p>
         * 
         * @param findings
         *        Information about the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(Collection<Finding> findings);

        /**
         * <p>
         * Information about the finding.
         * </p>
         * 
         * @param findings
         *        Information about the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(Finding... findings);

        /**
         * <p>
         * Information about the finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Finding>.Builder} avoiding the need to
         * create one manually via {@link List<Finding>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Finding>.Builder#build()} is called immediately and its
         * result is passed to {@link #findings(List<Finding>)}.
         * 
         * @param findings
         *        a consumer that will call methods on {@link List<Finding>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findings(List<Finding>)
         */
        Builder findings(Consumer<Finding.Builder>... findings);

        /**
         * <p>
         * Finding details that cannot be described. An error code is provided for each failed item.
         * </p>
         * 
         * @param failedItems
         *        Finding details that cannot be described. An error code is provided for each failed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(Map<String, FailedItemDetails> failedItems);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private List<Finding> findings = DefaultSdkAutoConstructList.getInstance();

        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFindingsResponse model) {
            super(model);
            findings(model.findings);
            failedItems(model.failedItems);
        }

        public final Collection<Finding.Builder> getFindings() {
            if (findings instanceof SdkAutoConstructList) {
                return null;
            }
            return findings != null ? findings.stream().map(Finding::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findings(Collection<Finding> findings) {
            this.findings = FindingListCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Finding... findings) {
            findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<Finding.Builder>... findings) {
            findings(Stream.of(findings).map(c -> Finding.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFindings(Collection<Finding.BuilderImpl> findings) {
            this.findings = FindingListCopier.copyFromBuilder(findings);
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            if (failedItems instanceof SdkAutoConstructMap) {
                return null;
            }
            return failedItems != null ? CollectionUtils.mapValues(failedItems, FailedItemDetails::toBuilder) : null;
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public DescribeFindingsResponse build() {
            return new DescribeFindingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
