/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector.model.AssessmentTemplate;
import software.amazon.awssdk.services.inspector.model.AssessmentTemplateListCopier;
import software.amazon.awssdk.services.inspector.model.FailedItemDetails;
import software.amazon.awssdk.services.inspector.model.FailedItemsCopier;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssessmentTemplatesResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, DescribeAssessmentTemplatesResponse> {
    private static final SdkField<List<AssessmentTemplate>> ASSESSMENT_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeAssessmentTemplatesResponse.getter(DescribeAssessmentTemplatesResponse::assessmentTemplates)).setter(DescribeAssessmentTemplatesResponse.setter(Builder::assessmentTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DescribeAssessmentTemplatesResponse.getter(DescribeAssessmentTemplatesResponse::failedItems)).setter(DescribeAssessmentTemplatesResponse.setter(Builder::failedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedItemDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TEMPLATES_FIELD, FAILED_ITEMS_FIELD));
    private final List<AssessmentTemplate> assessmentTemplates;
    private final Map<String, FailedItemDetails> failedItems;

    private DescribeAssessmentTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentTemplates = builder.assessmentTemplates;
        this.failedItems = builder.failedItems;
    }

    public boolean hasAssessmentTemplates() {
        return this.assessmentTemplates != null && !(this.assessmentTemplates instanceof SdkAutoConstructList);
    }

    public List<AssessmentTemplate> assessmentTemplates() {
        return this.assessmentTemplates;
    }

    public boolean hasFailedItems() {
        return this.failedItems != null && !(this.failedItems instanceof SdkAutoConstructMap);
    }

    public Map<String, FailedItemDetails> failedItems() {
        return this.failedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssessmentTemplatesResponse)) {
            return false;
        }
        DescribeAssessmentTemplatesResponse other = (DescribeAssessmentTemplatesResponse)((Object)obj);
        return Objects.equals(this.assessmentTemplates(), other.assessmentTemplates()) && Objects.equals(this.failedItems(), other.failedItems());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAssessmentTemplatesResponse").add("AssessmentTemplates", this.assessmentTemplates()).add("FailedItems", this.failedItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentTemplates": {
                return Optional.ofNullable(clazz.cast(this.assessmentTemplates()));
            }
            case "failedItems": {
                return Optional.ofNullable(clazz.cast(this.failedItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssessmentTemplatesResponse, T> g) {
        return obj -> g.apply((DescribeAssessmentTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<AssessmentTemplate> assessmentTemplates = DefaultSdkAutoConstructList.getInstance();
        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssessmentTemplatesResponse model) {
            super(model);
            this.assessmentTemplates(model.assessmentTemplates);
            this.failedItems(model.failedItems);
        }

        public final Collection<AssessmentTemplate.Builder> getAssessmentTemplates() {
            return this.assessmentTemplates != null ? (Collection)this.assessmentTemplates.stream().map(AssessmentTemplate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assessmentTemplates(Collection<AssessmentTemplate> assessmentTemplates) {
            this.assessmentTemplates = AssessmentTemplateListCopier.copy(assessmentTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTemplates(AssessmentTemplate ... assessmentTemplates) {
            this.assessmentTemplates(Arrays.asList(assessmentTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTemplates(Consumer<AssessmentTemplate.Builder> ... assessmentTemplates) {
            this.assessmentTemplates(Stream.of(assessmentTemplates).map(c -> (AssessmentTemplate)((AssessmentTemplate.Builder)AssessmentTemplate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssessmentTemplates(Collection<AssessmentTemplate.BuilderImpl> assessmentTemplates) {
            this.assessmentTemplates = AssessmentTemplateListCopier.copyFromBuilder(assessmentTemplates);
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            return this.failedItems != null ? CollectionUtils.mapValues(this.failedItems, FailedItemDetails::toBuilder) : null;
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public DescribeAssessmentTemplatesResponse build() {
            return new DescribeAssessmentTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssessmentTemplatesResponse> {
        public Builder assessmentTemplates(Collection<AssessmentTemplate> var1);

        public Builder assessmentTemplates(AssessmentTemplate ... var1);

        public Builder assessmentTemplates(Consumer<AssessmentTemplate.Builder> ... var1);

        public Builder failedItems(Map<String, FailedItemDetails> var1);
    }
}

