/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.imds;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.SdkHttpResponse;

@SdkPublicApi
public final class Ec2MetadataClientException
extends SdkClientException {
    private final int statusCode;
    private final SdkBytes rawResponse;
    private final SdkHttpResponse sdkHttpResponse;

    private Ec2MetadataClientException(BuilderImpl builder) {
        super((SdkClientException.Builder)builder);
        this.statusCode = builder.statusCode;
        this.rawResponse = builder.rawResponse;
        this.sdkHttpResponse = builder.sdkHttpResponse;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public SdkBytes rawResponse() {
        return this.rawResponse;
    }

    public SdkHttpResponse sdkHttpResponse() {
        return this.sdkHttpResponse;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static final class BuilderImpl
    extends SdkClientException.BuilderImpl
    implements Builder {
        private int statusCode;
        private SdkBytes rawResponse;
        private SdkHttpResponse sdkHttpResponse;

        private BuilderImpl() {
        }

        @Override
        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public Builder rawResponse(SdkBytes rawResponse) {
            this.rawResponse = rawResponse;
            return this;
        }

        @Override
        public Builder sdkHttpResponse(SdkHttpResponse sdkHttpResponse) {
            this.sdkHttpResponse = sdkHttpResponse;
            return this;
        }

        @Override
        public Ec2MetadataClientException build() {
            return new Ec2MetadataClientException(this);
        }
    }

    public static interface Builder
    extends SdkClientException.Builder {
        public Builder statusCode(int var1);

        public Builder rawResponse(SdkBytes var1);

        public Builder sdkHttpResponse(SdkHttpResponse var1);

        public Ec2MetadataClientException build();
    }
}

