/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.imds.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.imds.Ec2MetadataRetryPolicy;
import software.amazon.awssdk.imds.EndpointMode;
import software.amazon.awssdk.imds.internal.DefaultEc2MetadataAsyncClient;
import software.amazon.awssdk.imds.internal.DefaultEc2MetadataClient;
import software.amazon.awssdk.imds.internal.Ec2MetadataConfigProvider;
import software.amazon.awssdk.imds.internal.RequestMarshaller;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public abstract class BaseEc2MetadataClient {
    protected static final Duration DEFAULT_TOKEN_TTL = Duration.of(21600L, ChronoUnit.SECONDS);
    private static final software.amazon.awssdk.utils.Logger log = software.amazon.awssdk.utils.Logger.loggerFor(BaseEc2MetadataClient.class);
    protected final Ec2MetadataRetryPolicy retryPolicy;
    protected final URI endpoint;
    protected final RequestMarshaller requestMarshaller;
    protected final Duration tokenTtl;

    private BaseEc2MetadataClient(Ec2MetadataRetryPolicy retryPolicy, Duration tokenTtl, URI endpoint, EndpointMode endpointMode) {
        this.retryPolicy = (Ec2MetadataRetryPolicy)Validate.getOrDefault((Object)retryPolicy, () -> ((Ec2MetadataRetryPolicy.Builder)Ec2MetadataRetryPolicy.builder()).build());
        this.tokenTtl = (Duration)Validate.getOrDefault((Object)tokenTtl, () -> DEFAULT_TOKEN_TTL);
        this.endpoint = this.getEndpoint(endpoint, endpointMode);
        this.requestMarshaller = new RequestMarshaller(this.endpoint);
    }

    protected BaseEc2MetadataClient(DefaultEc2MetadataClient.Ec2MetadataBuilder builder) {
        this(builder.getRetryPolicy(), builder.getTokenTtl(), builder.getEndpoint(), builder.getEndpointMode());
    }

    protected BaseEc2MetadataClient(DefaultEc2MetadataAsyncClient.Ec2MetadataAsyncBuilder builder) {
        this(builder.getRetryPolicy(), builder.getTokenTtl(), builder.getEndpoint(), builder.getEndpointMode());
    }

    private URI getEndpoint(URI builderEndpoint, EndpointMode builderEndpointMode) {
        Validate.mutuallyExclusive((String)"Only one of 'endpoint' or 'endpointMode' must be specified, but not both", (Object[])new Object[]{builderEndpoint, builderEndpointMode});
        if (builderEndpoint != null) {
            return builderEndpoint;
        }
        if (builderEndpointMode != null) {
            return URI.create(Ec2MetadataConfigProvider.instance().resolveEndpoint(builderEndpointMode));
        }
        EndpointMode resolvedEndpointMode = Ec2MetadataConfigProvider.instance().resolveEndpointMode();
        return URI.create(Ec2MetadataConfigProvider.instance().resolveEndpoint(resolvedEndpointMode));
    }

    protected static String uncheckedInputStreamToUtf8(AbortableInputStream inputStream) {
        try {
            String string = IoUtils.toUtf8String((InputStream)inputStream);
            return string;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)inputStream, (Logger)log.logger());
        }
    }

    protected boolean shouldRetry(RetryPolicyContext retryPolicyContext, Throwable error) {
        boolean maxAttemptReached;
        boolean bl = maxAttemptReached = retryPolicyContext.retriesAttempted() >= this.retryPolicy.numRetries();
        if (maxAttemptReached) {
            return false;
        }
        return error instanceof RetryableException || error.getCause() instanceof RetryableException;
    }

    protected AttributeMap imdsHttpDefaults() {
        Duration metadataServiceTimeout = Ec2MetadataConfigProvider.instance().resolveServiceTimeout();
        return AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)metadataServiceTimeout).put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)metadataServiceTimeout).build();
    }
}

