/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.services.imagebuilder.model.LatestVersionReferences;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImageRecipeResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, CreateImageRecipeResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(CreateImageRecipeResponse.getter(CreateImageRecipeResponse::requestId)).setter(CreateImageRecipeResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateImageRecipeResponse.getter(CreateImageRecipeResponse::clientToken)).setter(CreateImageRecipeResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> IMAGE_RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageRecipeArn").getter(CreateImageRecipeResponse.getter(CreateImageRecipeResponse::imageRecipeArn)).setter(CreateImageRecipeResponse.setter(Builder::imageRecipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipeArn").build()}).build();
    private static final SdkField<LatestVersionReferences> LATEST_VERSION_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestVersionReferences").getter(CreateImageRecipeResponse.getter(CreateImageRecipeResponse::latestVersionReferences)).setter(CreateImageRecipeResponse.setter(Builder::latestVersionReferences)).constructor(LatestVersionReferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersionReferences").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, CLIENT_TOKEN_FIELD, IMAGE_RECIPE_ARN_FIELD, LATEST_VERSION_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateImageRecipeResponse.memberNameToFieldInitializer();
    private final String requestIdValue;
    private final String clientToken;
    private final String imageRecipeArn;
    private final LatestVersionReferences latestVersionReferences;

    private CreateImageRecipeResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.clientToken = builder.clientToken;
        this.imageRecipeArn = builder.imageRecipeArn;
        this.latestVersionReferences = builder.latestVersionReferences;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String imageRecipeArn() {
        return this.imageRecipeArn;
    }

    public final LatestVersionReferences latestVersionReferences() {
        return this.latestVersionReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionReferences());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRecipeResponse)) {
            return false;
        }
        CreateImageRecipeResponse other = (CreateImageRecipeResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.imageRecipeArn(), other.imageRecipeArn()) && Objects.equals(this.latestVersionReferences(), other.latestVersionReferences());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImageRecipeResponse").add("RequestId", (Object)this.requestId()).add("ClientToken", (Object)this.clientToken()).add("ImageRecipeArn", (Object)this.imageRecipeArn()).add("LatestVersionReferences", (Object)this.latestVersionReferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "imageRecipeArn": {
                return Optional.ofNullable(clazz.cast(this.imageRecipeArn()));
            }
            case "latestVersionReferences": {
                return Optional.ofNullable(clazz.cast(this.latestVersionReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("imageRecipeArn", IMAGE_RECIPE_ARN_FIELD);
        map.put("latestVersionReferences", LATEST_VERSION_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateImageRecipeResponse, T> g) {
        return obj -> g.apply((CreateImageRecipeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String clientToken;
        private String imageRecipeArn;
        private LatestVersionReferences latestVersionReferences;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageRecipeResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.clientToken(model.clientToken);
            this.imageRecipeArn(model.imageRecipeArn);
            this.latestVersionReferences(model.latestVersionReferences);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getImageRecipeArn() {
            return this.imageRecipeArn;
        }

        public final void setImageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
        }

        @Override
        public final Builder imageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        public final LatestVersionReferences.Builder getLatestVersionReferences() {
            return this.latestVersionReferences != null ? this.latestVersionReferences.toBuilder() : null;
        }

        public final void setLatestVersionReferences(LatestVersionReferences.BuilderImpl latestVersionReferences) {
            this.latestVersionReferences = latestVersionReferences != null ? latestVersionReferences.build() : null;
        }

        @Override
        public final Builder latestVersionReferences(LatestVersionReferences latestVersionReferences) {
            this.latestVersionReferences = latestVersionReferences;
            return this;
        }

        @Override
        public CreateImageRecipeResponse build() {
            return new CreateImageRecipeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImageRecipeResponse> {
        public Builder requestId(String var1);

        public Builder clientToken(String var1);

        public Builder imageRecipeArn(String var1);

        public Builder latestVersionReferences(LatestVersionReferences var1);

        default public Builder latestVersionReferences(Consumer<LatestVersionReferences.Builder> latestVersionReferences) {
            return this.latestVersionReferences((LatestVersionReferences)((LatestVersionReferences.Builder)LatestVersionReferences.builder().applyMutation(latestVersionReferences)).build());
        }
    }
}

