/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.BuildType;
import software.amazon.awssdk.services.imagebuilder.model.ImageSource;
import software.amazon.awssdk.services.imagebuilder.model.ImageState;
import software.amazon.awssdk.services.imagebuilder.model.ImageType;
import software.amazon.awssdk.services.imagebuilder.model.OutputResources;
import software.amazon.awssdk.services.imagebuilder.model.Platform;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ImageSummary.getter(ImageSummary::arn)).setter(ImageSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ImageSummary.getter(ImageSummary::name)).setter(ImageSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ImageSummary.getter(ImageSummary::typeAsString)).setter(ImageSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(ImageSummary.getter(ImageSummary::version)).setter(ImageSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(ImageSummary.getter(ImageSummary::platformAsString)).setter(ImageSummary.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osVersion").getter(ImageSummary.getter(ImageSummary::osVersion)).setter(ImageSummary.setter(Builder::osVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osVersion").build()}).build();
    private static final SdkField<ImageState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(ImageSummary.getter(ImageSummary::state)).setter(ImageSummary.setter(Builder::state)).constructor(ImageState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(ImageSummary.getter(ImageSummary::owner)).setter(ImageSummary.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateCreated").getter(ImageSummary.getter(ImageSummary::dateCreated)).setter(ImageSummary.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final SdkField<OutputResources> OUTPUT_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputResources").getter(ImageSummary.getter(ImageSummary::outputResources)).setter(ImageSummary.setter(Builder::outputResources)).constructor(OutputResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputResources").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ImageSummary.getter(ImageSummary::tags)).setter(ImageSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> BUILD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildType").getter(ImageSummary.getter(ImageSummary::buildTypeAsString)).setter(ImageSummary.setter(Builder::buildType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildType").build()}).build();
    private static final SdkField<String> IMAGE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSource").getter(ImageSummary.getter(ImageSummary::imageSourceAsString)).setter(ImageSummary.setter(Builder::imageSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSource").build()}).build();
    private static final SdkField<Instant> DEPRECATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("deprecationTime").getter(ImageSummary.getter(ImageSummary::deprecationTime)).setter(ImageSummary.setter(Builder::deprecationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationTime").build()}).build();
    private static final SdkField<String> LIFECYCLE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleExecutionId").getter(ImageSummary.getter(ImageSummary::lifecycleExecutionId)).setter(ImageSummary.setter(Builder::lifecycleExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleExecutionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, TYPE_FIELD, VERSION_FIELD, PLATFORM_FIELD, OS_VERSION_FIELD, STATE_FIELD, OWNER_FIELD, DATE_CREATED_FIELD, OUTPUT_RESOURCES_FIELD, TAGS_FIELD, BUILD_TYPE_FIELD, IMAGE_SOURCE_FIELD, DEPRECATION_TIME_FIELD, LIFECYCLE_EXECUTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String type;
    private final String version;
    private final String platform;
    private final String osVersion;
    private final ImageState state;
    private final String owner;
    private final String dateCreated;
    private final OutputResources outputResources;
    private final Map<String, String> tags;
    private final String buildType;
    private final String imageSource;
    private final Instant deprecationTime;
    private final String lifecycleExecutionId;

    private ImageSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.version = builder.version;
        this.platform = builder.platform;
        this.osVersion = builder.osVersion;
        this.state = builder.state;
        this.owner = builder.owner;
        this.dateCreated = builder.dateCreated;
        this.outputResources = builder.outputResources;
        this.tags = builder.tags;
        this.buildType = builder.buildType;
        this.imageSource = builder.imageSource;
        this.deprecationTime = builder.deprecationTime;
        this.lifecycleExecutionId = builder.lifecycleExecutionId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final ImageType type() {
        return ImageType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String version() {
        return this.version;
    }

    public final Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final String osVersion() {
        return this.osVersion;
    }

    public final ImageState state() {
        return this.state;
    }

    public final String owner() {
        return this.owner;
    }

    public final String dateCreated() {
        return this.dateCreated;
    }

    public final OutputResources outputResources() {
        return this.outputResources;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final BuildType buildType() {
        return BuildType.fromValue(this.buildType);
    }

    public final String buildTypeAsString() {
        return this.buildType;
    }

    public final ImageSource imageSource() {
        return ImageSource.fromValue(this.imageSource);
    }

    public final String imageSourceAsString() {
        return this.imageSource;
    }

    public final Instant deprecationTime() {
        return this.deprecationTime;
    }

    public final String lifecycleExecutionId() {
        return this.lifecycleExecutionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.buildTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleExecutionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSummary)) {
            return false;
        }
        ImageSummary other = (ImageSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.osVersion(), other.osVersion()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.outputResources(), other.outputResources()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.buildTypeAsString(), other.buildTypeAsString()) && Objects.equals(this.imageSourceAsString(), other.imageSourceAsString()) && Objects.equals(this.deprecationTime(), other.deprecationTime()) && Objects.equals(this.lifecycleExecutionId(), other.lifecycleExecutionId());
    }

    public final String toString() {
        return ToString.builder((String)"ImageSummary").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Version", (Object)this.version()).add("Platform", (Object)this.platformAsString()).add("OsVersion", (Object)this.osVersion()).add("State", (Object)this.state()).add("Owner", (Object)this.owner()).add("DateCreated", (Object)this.dateCreated()).add("OutputResources", (Object)this.outputResources()).add("Tags", this.hasTags() ? this.tags() : null).add("BuildType", (Object)this.buildTypeAsString()).add("ImageSource", (Object)this.imageSourceAsString()).add("DeprecationTime", (Object)this.deprecationTime()).add("LifecycleExecutionId", (Object)this.lifecycleExecutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "osVersion": {
                return Optional.ofNullable(clazz.cast(this.osVersion()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "outputResources": {
                return Optional.ofNullable(clazz.cast(this.outputResources()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "buildType": {
                return Optional.ofNullable(clazz.cast(this.buildTypeAsString()));
            }
            case "imageSource": {
                return Optional.ofNullable(clazz.cast(this.imageSourceAsString()));
            }
            case "deprecationTime": {
                return Optional.ofNullable(clazz.cast(this.deprecationTime()));
            }
            case "lifecycleExecutionId": {
                return Optional.ofNullable(clazz.cast(this.lifecycleExecutionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("osVersion", OS_VERSION_FIELD);
        map.put("state", STATE_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("dateCreated", DATE_CREATED_FIELD);
        map.put("outputResources", OUTPUT_RESOURCES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("buildType", BUILD_TYPE_FIELD);
        map.put("imageSource", IMAGE_SOURCE_FIELD);
        map.put("deprecationTime", DEPRECATION_TIME_FIELD);
        map.put("lifecycleExecutionId", LIFECYCLE_EXECUTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageSummary, T> g) {
        return obj -> g.apply((ImageSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private String version;
        private String platform;
        private String osVersion;
        private ImageState state;
        private String owner;
        private String dateCreated;
        private OutputResources outputResources;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String buildType;
        private String imageSource;
        private Instant deprecationTime;
        private String lifecycleExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSummary model) {
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.version(model.version);
            this.platform(model.platform);
            this.osVersion(model.osVersion);
            this.state(model.state);
            this.owner(model.owner);
            this.dateCreated(model.dateCreated);
            this.outputResources(model.outputResources);
            this.tags(model.tags);
            this.buildType(model.buildType);
            this.imageSource(model.imageSource);
            this.deprecationTime(model.deprecationTime);
            this.lifecycleExecutionId(model.lifecycleExecutionId);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ImageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getOsVersion() {
            return this.osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final ImageState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(ImageState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state = state;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final OutputResources.Builder getOutputResources() {
            return this.outputResources != null ? this.outputResources.toBuilder() : null;
        }

        public final void setOutputResources(OutputResources.BuilderImpl outputResources) {
            this.outputResources = outputResources != null ? outputResources.build() : null;
        }

        @Override
        public final Builder outputResources(OutputResources outputResources) {
            this.outputResources = outputResources;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getBuildType() {
            return this.buildType;
        }

        public final void setBuildType(String buildType) {
            this.buildType = buildType;
        }

        @Override
        public final Builder buildType(String buildType) {
            this.buildType = buildType;
            return this;
        }

        @Override
        public final Builder buildType(BuildType buildType) {
            this.buildType(buildType == null ? null : buildType.toString());
            return this;
        }

        public final String getImageSource() {
            return this.imageSource;
        }

        public final void setImageSource(String imageSource) {
            this.imageSource = imageSource;
        }

        @Override
        public final Builder imageSource(String imageSource) {
            this.imageSource = imageSource;
            return this;
        }

        @Override
        public final Builder imageSource(ImageSource imageSource) {
            this.imageSource(imageSource == null ? null : imageSource.toString());
            return this;
        }

        public final Instant getDeprecationTime() {
            return this.deprecationTime;
        }

        public final void setDeprecationTime(Instant deprecationTime) {
            this.deprecationTime = deprecationTime;
        }

        @Override
        public final Builder deprecationTime(Instant deprecationTime) {
            this.deprecationTime = deprecationTime;
            return this;
        }

        public final String getLifecycleExecutionId() {
            return this.lifecycleExecutionId;
        }

        public final void setLifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
        }

        @Override
        public final Builder lifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
            return this;
        }

        public ImageSummary build() {
            return new ImageSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageSummary> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ImageType var1);

        public Builder version(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder osVersion(String var1);

        public Builder state(ImageState var1);

        default public Builder state(Consumer<ImageState.Builder> state) {
            return this.state((ImageState)((ImageState.Builder)ImageState.builder().applyMutation(state)).build());
        }

        public Builder owner(String var1);

        public Builder dateCreated(String var1);

        public Builder outputResources(OutputResources var1);

        default public Builder outputResources(Consumer<OutputResources.Builder> outputResources) {
            return this.outputResources((OutputResources)((OutputResources.Builder)OutputResources.builder().applyMutation(outputResources)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder buildType(String var1);

        public Builder buildType(BuildType var1);

        public Builder imageSource(String var1);

        public Builder imageSource(ImageSource var1);

        public Builder deprecationTime(Instant var1);

        public Builder lifecycleExecutionId(String var1);
    }
}

