/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.SsmParameterDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SsmParameterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SsmParameterConfiguration> {
    private static final SdkField<String> AMI_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("amiAccountId").getter(SsmParameterConfiguration.getter(SsmParameterConfiguration::amiAccountId)).setter(SsmParameterConfiguration.setter(Builder::amiAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiAccountId").build()}).build();
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parameterName").getter(SsmParameterConfiguration.getter(SsmParameterConfiguration::parameterName)).setter(SsmParameterConfiguration.setter(Builder::parameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterName").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(SsmParameterConfiguration.getter(SsmParameterConfiguration::dataTypeAsString)).setter(SsmParameterConfiguration.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMI_ACCOUNT_ID_FIELD, PARAMETER_NAME_FIELD, DATA_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SsmParameterConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String amiAccountId;
    private final String parameterName;
    private final String dataType;

    private SsmParameterConfiguration(BuilderImpl builder) {
        this.amiAccountId = builder.amiAccountId;
        this.parameterName = builder.parameterName;
        this.dataType = builder.dataType;
    }

    public final String amiAccountId() {
        return this.amiAccountId;
    }

    public final String parameterName() {
        return this.parameterName;
    }

    public final SsmParameterDataType dataType() {
        return SsmParameterDataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amiAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmParameterConfiguration)) {
            return false;
        }
        SsmParameterConfiguration other = (SsmParameterConfiguration)obj;
        return Objects.equals(this.amiAccountId(), other.amiAccountId()) && Objects.equals(this.parameterName(), other.parameterName()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SsmParameterConfiguration").add("AmiAccountId", (Object)this.amiAccountId()).add("ParameterName", (Object)this.parameterName()).add("DataType", (Object)this.dataTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amiAccountId": {
                return Optional.ofNullable(clazz.cast(this.amiAccountId()));
            }
            case "parameterName": {
                return Optional.ofNullable(clazz.cast(this.parameterName()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("amiAccountId", AMI_ACCOUNT_ID_FIELD);
        map.put("parameterName", PARAMETER_NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SsmParameterConfiguration, T> g) {
        return obj -> g.apply((SsmParameterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String amiAccountId;
        private String parameterName;
        private String dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(SsmParameterConfiguration model) {
            this.amiAccountId(model.amiAccountId);
            this.parameterName(model.parameterName);
            this.dataType(model.dataType);
        }

        public final String getAmiAccountId() {
            return this.amiAccountId;
        }

        public final void setAmiAccountId(String amiAccountId) {
            this.amiAccountId = amiAccountId;
        }

        @Override
        public final Builder amiAccountId(String amiAccountId) {
            this.amiAccountId = amiAccountId;
            return this;
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(SsmParameterDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public SsmParameterConfiguration build() {
            return new SsmParameterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SsmParameterConfiguration> {
        public Builder amiAccountId(String var1);

        public Builder parameterName(String var1);

        public Builder dataType(String var1);

        public Builder dataType(SsmParameterDataType var1);
    }
}

