/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionsListCopier;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowStepMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkflowStepExecutionsResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListWorkflowStepExecutionsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(ListWorkflowStepExecutionsResponse.getter(ListWorkflowStepExecutionsResponse::requestId)).setter(ListWorkflowStepExecutionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<List<WorkflowStepMetadata>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("steps").getter(ListWorkflowStepExecutionsResponse.getter(ListWorkflowStepExecutionsResponse::steps)).setter(ListWorkflowStepExecutionsResponse.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKFLOW_BUILD_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowBuildVersionArn").getter(ListWorkflowStepExecutionsResponse.getter(ListWorkflowStepExecutionsResponse::workflowBuildVersionArn)).setter(ListWorkflowStepExecutionsResponse.setter(Builder::workflowBuildVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBuildVersionArn").build()}).build();
    private static final SdkField<String> WORKFLOW_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowExecutionId").getter(ListWorkflowStepExecutionsResponse.getter(ListWorkflowStepExecutionsResponse::workflowExecutionId)).setter(ListWorkflowStepExecutionsResponse.setter(Builder::workflowExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecutionId").build()}).build();
    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageBuildVersionArn").getter(ListWorkflowStepExecutionsResponse.getter(ListWorkflowStepExecutionsResponse::imageBuildVersionArn)).setter(ListWorkflowStepExecutionsResponse.setter(Builder::imageBuildVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBuildVersionArn").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(ListWorkflowStepExecutionsResponse.getter(ListWorkflowStepExecutionsResponse::message)).setter(ListWorkflowStepExecutionsResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkflowStepExecutionsResponse.getter(ListWorkflowStepExecutionsResponse::nextToken)).setter(ListWorkflowStepExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, STEPS_FIELD, WORKFLOW_BUILD_VERSION_ARN_FIELD, WORKFLOW_EXECUTION_ID_FIELD, IMAGE_BUILD_VERSION_ARN_FIELD, MESSAGE_FIELD, NEXT_TOKEN_FIELD));
    private final String requestIdValue;
    private final List<WorkflowStepMetadata> steps;
    private final String workflowBuildVersionArn;
    private final String workflowExecutionId;
    private final String imageBuildVersionArn;
    private final String message;
    private final String nextToken;

    private ListWorkflowStepExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.steps = builder.steps;
        this.workflowBuildVersionArn = builder.workflowBuildVersionArn;
        this.workflowExecutionId = builder.workflowExecutionId;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.message = builder.message;
        this.nextToken = builder.nextToken;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<WorkflowStepMetadata> steps() {
        return this.steps;
    }

    public final String workflowBuildVersionArn() {
        return this.workflowBuildVersionArn;
    }

    public final String workflowExecutionId() {
        return this.workflowExecutionId;
    }

    public final String imageBuildVersionArn() {
        return this.imageBuildVersionArn;
    }

    public final String message() {
        return this.message;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowStepExecutionsResponse)) {
            return false;
        }
        ListWorkflowStepExecutionsResponse other = (ListWorkflowStepExecutionsResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps()) && Objects.equals(this.workflowBuildVersionArn(), other.workflowBuildVersionArn()) && Objects.equals(this.workflowExecutionId(), other.workflowExecutionId()) && Objects.equals(this.imageBuildVersionArn(), other.imageBuildVersionArn()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkflowStepExecutionsResponse").add("RequestId", (Object)this.requestId()).add("Steps", this.hasSteps() ? this.steps() : null).add("WorkflowBuildVersionArn", (Object)this.workflowBuildVersionArn()).add("WorkflowExecutionId", (Object)this.workflowExecutionId()).add("ImageBuildVersionArn", (Object)this.imageBuildVersionArn()).add("Message", (Object)this.message()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "workflowBuildVersionArn": {
                return Optional.ofNullable(clazz.cast(this.workflowBuildVersionArn()));
            }
            case "workflowExecutionId": {
                return Optional.ofNullable(clazz.cast(this.workflowExecutionId()));
            }
            case "imageBuildVersionArn": {
                return Optional.ofNullable(clazz.cast(this.imageBuildVersionArn()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowStepExecutionsResponse, T> g) {
        return obj -> g.apply((ListWorkflowStepExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private List<WorkflowStepMetadata> steps = DefaultSdkAutoConstructList.getInstance();
        private String workflowBuildVersionArn;
        private String workflowExecutionId;
        private String imageBuildVersionArn;
        private String message;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowStepExecutionsResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.steps(model.steps);
            this.workflowBuildVersionArn(model.workflowBuildVersionArn);
            this.workflowExecutionId(model.workflowExecutionId);
            this.imageBuildVersionArn(model.imageBuildVersionArn);
            this.message(model.message);
            this.nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final List<WorkflowStepMetadata.Builder> getSteps() {
            List<WorkflowStepMetadata.Builder> result = WorkflowStepExecutionsListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<WorkflowStepMetadata.BuilderImpl> steps) {
            this.steps = WorkflowStepExecutionsListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<WorkflowStepMetadata> steps) {
            this.steps = WorkflowStepExecutionsListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(WorkflowStepMetadata ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<WorkflowStepMetadata.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (WorkflowStepMetadata)((WorkflowStepMetadata.Builder)WorkflowStepMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkflowBuildVersionArn() {
            return this.workflowBuildVersionArn;
        }

        public final void setWorkflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
        }

        @Override
        public final Builder workflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
            return this;
        }

        public final String getWorkflowExecutionId() {
            return this.workflowExecutionId;
        }

        public final void setWorkflowExecutionId(String workflowExecutionId) {
            this.workflowExecutionId = workflowExecutionId;
        }

        @Override
        public final Builder workflowExecutionId(String workflowExecutionId) {
            this.workflowExecutionId = workflowExecutionId;
            return this;
        }

        public final String getImageBuildVersionArn() {
            return this.imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkflowStepExecutionsResponse build() {
            return new ListWorkflowStepExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkflowStepExecutionsResponse> {
        public Builder requestId(String var1);

        public Builder steps(Collection<WorkflowStepMetadata> var1);

        public Builder steps(WorkflowStepMetadata ... var1);

        public Builder steps(Consumer<WorkflowStepMetadata.Builder> ... var1);

        public Builder workflowBuildVersionArn(String var1);

        public Builder workflowExecutionId(String var1);

        public Builder imageBuildVersionArn(String var1);

        public Builder message(String var1);

        public Builder nextToken(String var1);
    }
}

