/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowSummary;

public class ListWorkflowBuildVersionsIterable
implements SdkIterable<ListWorkflowBuildVersionsResponse> {
    private final ImagebuilderClient client;
    private final ListWorkflowBuildVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowBuildVersionsIterable(ImagebuilderClient client, ListWorkflowBuildVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkflowBuildVersionsResponseFetcher();
    }

    public Iterator<ListWorkflowBuildVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowSummary> workflowSummaryList() {
        Function<ListWorkflowBuildVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowSummaryList() != null) {
                return response.workflowSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowBuildVersionsResponseFetcher
    implements SyncPageFetcher<ListWorkflowBuildVersionsResponse> {
        private ListWorkflowBuildVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowBuildVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowBuildVersionsResponse nextPage(ListWorkflowBuildVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowBuildVersionsIterable.this.client.listWorkflowBuildVersions(ListWorkflowBuildVersionsIterable.this.firstRequest);
            }
            return ListWorkflowBuildVersionsIterable.this.client.listWorkflowBuildVersions((ListWorkflowBuildVersionsRequest)((Object)ListWorkflowBuildVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

