/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkflowExecutionStatus {
    PENDING("PENDING"),
    SKIPPED("SKIPPED"),
    RUNNING("RUNNING"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    ROLLBACK_IN_PROGRESS("ROLLBACK_IN_PROGRESS"),
    ROLLBACK_COMPLETED("ROLLBACK_COMPLETED"),
    CANCELLED("CANCELLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkflowExecutionStatus> VALUE_MAP;
    private final String value;

    private WorkflowExecutionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkflowExecutionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkflowExecutionStatus> knownValues() {
        EnumSet<WorkflowExecutionStatus> knownValues = EnumSet.allOf(WorkflowExecutionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkflowExecutionStatus.class, WorkflowExecutionStatus::toString);
    }
}

