/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceAction;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceState;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionSnapshotResource;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionSnapshotResourceListCopier;
import software.amazon.awssdk.services.imagebuilder.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecycleExecutionResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecycleExecutionResource> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(LifecycleExecutionResource.getter(LifecycleExecutionResource::accountId)).setter(LifecycleExecutionResource.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(LifecycleExecutionResource.getter(LifecycleExecutionResource::resourceId)).setter(LifecycleExecutionResource.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<LifecycleExecutionResourceState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(LifecycleExecutionResource.getter(LifecycleExecutionResource::state)).setter(LifecycleExecutionResource.setter(Builder::state)).constructor(LifecycleExecutionResourceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<LifecycleExecutionResourceAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("action").getter(LifecycleExecutionResource.getter(LifecycleExecutionResource::action)).setter(LifecycleExecutionResource.setter(Builder::action)).constructor(LifecycleExecutionResourceAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(LifecycleExecutionResource.getter(LifecycleExecutionResource::region)).setter(LifecycleExecutionResource.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<List<LifecycleExecutionSnapshotResource>> SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("snapshots").getter(LifecycleExecutionResource.getter(LifecycleExecutionResource::snapshots)).setter(LifecycleExecutionResource.setter(Builder::snapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecycleExecutionSnapshotResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMAGE_URIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageUris").getter(LifecycleExecutionResource.getter(LifecycleExecutionResource::imageUris)).setter(LifecycleExecutionResource.setter(Builder::imageUris)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageUris").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(LifecycleExecutionResource.getter(LifecycleExecutionResource::startTime)).setter(LifecycleExecutionResource.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(LifecycleExecutionResource.getter(LifecycleExecutionResource::endTime)).setter(LifecycleExecutionResource.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, RESOURCE_ID_FIELD, STATE_FIELD, ACTION_FIELD, REGION_FIELD, SNAPSHOTS_FIELD, IMAGE_URIS_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String resourceId;
    private final LifecycleExecutionResourceState state;
    private final LifecycleExecutionResourceAction action;
    private final String region;
    private final List<LifecycleExecutionSnapshotResource> snapshots;
    private final List<String> imageUris;
    private final Instant startTime;
    private final Instant endTime;

    private LifecycleExecutionResource(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.resourceId = builder.resourceId;
        this.state = builder.state;
        this.action = builder.action;
        this.region = builder.region;
        this.snapshots = builder.snapshots;
        this.imageUris = builder.imageUris;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final LifecycleExecutionResourceState state() {
        return this.state;
    }

    public final LifecycleExecutionResourceAction action() {
        return this.action;
    }

    public final String region() {
        return this.region;
    }

    public final boolean hasSnapshots() {
        return this.snapshots != null && !(this.snapshots instanceof SdkAutoConstructList);
    }

    public final List<LifecycleExecutionSnapshotResource> snapshots() {
        return this.snapshots;
    }

    public final boolean hasImageUris() {
        return this.imageUris != null && !(this.imageUris instanceof SdkAutoConstructList);
    }

    public final List<String> imageUris() {
        return this.imageUris;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshots() ? this.snapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageUris() ? this.imageUris() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleExecutionResource)) {
            return false;
        }
        LifecycleExecutionResource other = (LifecycleExecutionResource)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.region(), other.region()) && this.hasSnapshots() == other.hasSnapshots() && Objects.equals(this.snapshots(), other.snapshots()) && this.hasImageUris() == other.hasImageUris() && Objects.equals(this.imageUris(), other.imageUris()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"LifecycleExecutionResource").add("AccountId", (Object)this.accountId()).add("ResourceId", (Object)this.resourceId()).add("State", (Object)this.state()).add("Action", (Object)this.action()).add("Region", (Object)this.region()).add("Snapshots", this.hasSnapshots() ? this.snapshots() : null).add("ImageUris", this.hasImageUris() ? this.imageUris() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "snapshots": {
                return Optional.ofNullable(clazz.cast(this.snapshots()));
            }
            case "imageUris": {
                return Optional.ofNullable(clazz.cast(this.imageUris()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecycleExecutionResource, T> g) {
        return obj -> g.apply((LifecycleExecutionResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String resourceId;
        private LifecycleExecutionResourceState state;
        private LifecycleExecutionResourceAction action;
        private String region;
        private List<LifecycleExecutionSnapshotResource> snapshots = DefaultSdkAutoConstructList.getInstance();
        private List<String> imageUris = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleExecutionResource model) {
            this.accountId(model.accountId);
            this.resourceId(model.resourceId);
            this.state(model.state);
            this.action(model.action);
            this.region(model.region);
            this.snapshots(model.snapshots);
            this.imageUris(model.imageUris);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final LifecycleExecutionResourceState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(LifecycleExecutionResourceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(LifecycleExecutionResourceState state) {
            this.state = state;
            return this;
        }

        public final LifecycleExecutionResourceAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(LifecycleExecutionResourceAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(LifecycleExecutionResourceAction action) {
            this.action = action;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final List<LifecycleExecutionSnapshotResource.Builder> getSnapshots() {
            List<LifecycleExecutionSnapshotResource.Builder> result = LifecycleExecutionSnapshotResourceListCopier.copyToBuilder(this.snapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshots(Collection<LifecycleExecutionSnapshotResource.BuilderImpl> snapshots) {
            this.snapshots = LifecycleExecutionSnapshotResourceListCopier.copyFromBuilder(snapshots);
        }

        @Override
        public final Builder snapshots(Collection<LifecycleExecutionSnapshotResource> snapshots) {
            this.snapshots = LifecycleExecutionSnapshotResourceListCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(LifecycleExecutionSnapshotResource ... snapshots) {
            this.snapshots(Arrays.asList(snapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Consumer<LifecycleExecutionSnapshotResource.Builder> ... snapshots) {
            this.snapshots(Stream.of(snapshots).map(c -> (LifecycleExecutionSnapshotResource)((LifecycleExecutionSnapshotResource.Builder)LifecycleExecutionSnapshotResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getImageUris() {
            if (this.imageUris instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageUris;
        }

        public final void setImageUris(Collection<String> imageUris) {
            this.imageUris = StringListCopier.copy(imageUris);
        }

        @Override
        public final Builder imageUris(Collection<String> imageUris) {
            this.imageUris = StringListCopier.copy(imageUris);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageUris(String ... imageUris) {
            this.imageUris(Arrays.asList(imageUris));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public LifecycleExecutionResource build() {
            return new LifecycleExecutionResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecycleExecutionResource> {
        public Builder accountId(String var1);

        public Builder resourceId(String var1);

        public Builder state(LifecycleExecutionResourceState var1);

        default public Builder state(Consumer<LifecycleExecutionResourceState.Builder> state) {
            return this.state((LifecycleExecutionResourceState)((LifecycleExecutionResourceState.Builder)LifecycleExecutionResourceState.builder().applyMutation(state)).build());
        }

        public Builder action(LifecycleExecutionResourceAction var1);

        default public Builder action(Consumer<LifecycleExecutionResourceAction.Builder> action) {
            return this.action((LifecycleExecutionResourceAction)((LifecycleExecutionResourceAction.Builder)LifecycleExecutionResourceAction.builder().applyMutation(action)).build());
        }

        public Builder region(String var1);

        public Builder snapshots(Collection<LifecycleExecutionSnapshotResource> var1);

        public Builder snapshots(LifecycleExecutionSnapshotResource ... var1);

        public Builder snapshots(Consumer<LifecycleExecutionSnapshotResource.Builder> ... var1);

        public Builder imageUris(Collection<String> var1);

        public Builder imageUris(String ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

