/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingAggregation;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsResponse;

public class ListImageScanFindingAggregationsPublisher
implements SdkPublisher<ListImageScanFindingAggregationsResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListImageScanFindingAggregationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImageScanFindingAggregationsPublisher(ImagebuilderAsyncClient client, ListImageScanFindingAggregationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImageScanFindingAggregationsPublisher(ImagebuilderAsyncClient client, ListImageScanFindingAggregationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImageScanFindingAggregationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImageScanFindingAggregationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageScanFindingAggregation> responses() {
        Function<ListImageScanFindingAggregationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.responses() != null) {
                return response.responses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListImageScanFindingAggregationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListImageScanFindingAggregationsResponseFetcher
    implements AsyncPageFetcher<ListImageScanFindingAggregationsResponse> {
        private ListImageScanFindingAggregationsResponseFetcher() {
        }

        public boolean hasNextPage(ListImageScanFindingAggregationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImageScanFindingAggregationsResponse> nextPage(ListImageScanFindingAggregationsResponse previousPage) {
            if (previousPage == null) {
                return ListImageScanFindingAggregationsPublisher.this.client.listImageScanFindingAggregations(ListImageScanFindingAggregationsPublisher.this.firstRequest);
            }
            return ListImageScanFindingAggregationsPublisher.this.client.listImageScanFindingAggregations((ListImageScanFindingAggregationsRequest)((Object)ListImageScanFindingAggregationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

