/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionMetadata;

public class ListWorkflowExecutionsIterable
implements SdkIterable<ListWorkflowExecutionsResponse> {
    private final ImagebuilderClient client;
    private final ListWorkflowExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowExecutionsIterable(ImagebuilderClient client, ListWorkflowExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorkflowExecutionsResponseFetcher();
    }

    public Iterator<ListWorkflowExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowExecutionMetadata> workflowExecutions() {
        Function<ListWorkflowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowExecutions() != null) {
                return response.workflowExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowExecutionsResponseFetcher
    implements SyncPageFetcher<ListWorkflowExecutionsResponse> {
        private ListWorkflowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowExecutionsResponse nextPage(ListWorkflowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowExecutionsIterable.this.client.listWorkflowExecutions(ListWorkflowExecutionsIterable.this.firstRequest);
            }
            return ListWorkflowExecutionsIterable.this.client.listWorkflowExecutions((ListWorkflowExecutionsRequest)((Object)ListWorkflowExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

