/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInfrastructureConfigurationResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, GetInfrastructureConfigurationResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(GetInfrastructureConfigurationResponse.getter(GetInfrastructureConfigurationResponse::requestId)).setter(GetInfrastructureConfigurationResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<InfrastructureConfiguration> INFRASTRUCTURE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("infrastructureConfiguration").getter(GetInfrastructureConfigurationResponse.getter(GetInfrastructureConfigurationResponse::infrastructureConfiguration)).setter(GetInfrastructureConfigurationResponse.setter(Builder::infrastructureConfiguration)).constructor(InfrastructureConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, INFRASTRUCTURE_CONFIGURATION_FIELD));
    private final String requestIdValue;
    private final InfrastructureConfiguration infrastructureConfiguration;

    private GetInfrastructureConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.infrastructureConfiguration = builder.infrastructureConfiguration;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final InfrastructureConfiguration infrastructureConfiguration() {
        return this.infrastructureConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInfrastructureConfigurationResponse)) {
            return false;
        }
        GetInfrastructureConfigurationResponse other = (GetInfrastructureConfigurationResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.infrastructureConfiguration(), other.infrastructureConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetInfrastructureConfigurationResponse").add("RequestId", (Object)this.requestId()).add("InfrastructureConfiguration", (Object)this.infrastructureConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "infrastructureConfiguration": {
                return Optional.ofNullable(clazz.cast(this.infrastructureConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInfrastructureConfigurationResponse, T> g) {
        return obj -> g.apply((GetInfrastructureConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private InfrastructureConfiguration infrastructureConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInfrastructureConfigurationResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.infrastructureConfiguration(model.infrastructureConfiguration);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        @Transient
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final InfrastructureConfiguration.Builder getInfrastructureConfiguration() {
            return this.infrastructureConfiguration != null ? this.infrastructureConfiguration.toBuilder() : null;
        }

        public final void setInfrastructureConfiguration(InfrastructureConfiguration.BuilderImpl infrastructureConfiguration) {
            this.infrastructureConfiguration = infrastructureConfiguration != null ? infrastructureConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder infrastructureConfiguration(InfrastructureConfiguration infrastructureConfiguration) {
            this.infrastructureConfiguration = infrastructureConfiguration;
            return this;
        }

        @Override
        public GetInfrastructureConfigurationResponse build() {
            return new GetInfrastructureConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInfrastructureConfigurationResponse> {
        public Builder requestId(String var1);

        public Builder infrastructureConfiguration(InfrastructureConfiguration var1);

        default public Builder infrastructureConfiguration(Consumer<InfrastructureConfiguration.Builder> infrastructureConfiguration) {
            return this.infrastructureConfiguration((InfrastructureConfiguration)((InfrastructureConfiguration.Builder)InfrastructureConfiguration.builder().applyMutation(infrastructureConfiguration)).build());
        }
    }
}

