/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.FastLaunchLaunchTemplateSpecification;
import software.amazon.awssdk.services.imagebuilder.model.FastLaunchSnapshotConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FastLaunchConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FastLaunchConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(FastLaunchConfiguration.getter(FastLaunchConfiguration::enabled)).setter(FastLaunchConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<FastLaunchSnapshotConfiguration> SNAPSHOT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("snapshotConfiguration").getter(FastLaunchConfiguration.getter(FastLaunchConfiguration::snapshotConfiguration)).setter(FastLaunchConfiguration.setter(Builder::snapshotConfiguration)).constructor(FastLaunchSnapshotConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotConfiguration").build()}).build();
    private static final SdkField<Integer> MAX_PARALLEL_LAUNCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxParallelLaunches").getter(FastLaunchConfiguration.getter(FastLaunchConfiguration::maxParallelLaunches)).setter(FastLaunchConfiguration.setter(Builder::maxParallelLaunches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxParallelLaunches").build()}).build();
    private static final SdkField<FastLaunchLaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchTemplate").getter(FastLaunchConfiguration.getter(FastLaunchConfiguration::launchTemplate)).setter(FastLaunchConfiguration.setter(Builder::launchTemplate)).constructor(FastLaunchLaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplate").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(FastLaunchConfiguration.getter(FastLaunchConfiguration::accountId)).setter(FastLaunchConfiguration.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, SNAPSHOT_CONFIGURATION_FIELD, MAX_PARALLEL_LAUNCHES_FIELD, LAUNCH_TEMPLATE_FIELD, ACCOUNT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final FastLaunchSnapshotConfiguration snapshotConfiguration;
    private final Integer maxParallelLaunches;
    private final FastLaunchLaunchTemplateSpecification launchTemplate;
    private final String accountId;

    private FastLaunchConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.snapshotConfiguration = builder.snapshotConfiguration;
        this.maxParallelLaunches = builder.maxParallelLaunches;
        this.launchTemplate = builder.launchTemplate;
        this.accountId = builder.accountId;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final FastLaunchSnapshotConfiguration snapshotConfiguration() {
        return this.snapshotConfiguration;
    }

    public final Integer maxParallelLaunches() {
        return this.maxParallelLaunches;
    }

    public final FastLaunchLaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public final String accountId() {
        return this.accountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxParallelLaunches());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FastLaunchConfiguration)) {
            return false;
        }
        FastLaunchConfiguration other = (FastLaunchConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.snapshotConfiguration(), other.snapshotConfiguration()) && Objects.equals(this.maxParallelLaunches(), other.maxParallelLaunches()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.accountId(), other.accountId());
    }

    public final String toString() {
        return ToString.builder((String)"FastLaunchConfiguration").add("Enabled", (Object)this.enabled()).add("SnapshotConfiguration", (Object)this.snapshotConfiguration()).add("MaxParallelLaunches", (Object)this.maxParallelLaunches()).add("LaunchTemplate", (Object)this.launchTemplate()).add("AccountId", (Object)this.accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "snapshotConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snapshotConfiguration()));
            }
            case "maxParallelLaunches": {
                return Optional.ofNullable(clazz.cast(this.maxParallelLaunches()));
            }
            case "launchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FastLaunchConfiguration, T> g) {
        return obj -> g.apply((FastLaunchConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private FastLaunchSnapshotConfiguration snapshotConfiguration;
        private Integer maxParallelLaunches;
        private FastLaunchLaunchTemplateSpecification launchTemplate;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(FastLaunchConfiguration model) {
            this.enabled(model.enabled);
            this.snapshotConfiguration(model.snapshotConfiguration);
            this.maxParallelLaunches(model.maxParallelLaunches);
            this.launchTemplate(model.launchTemplate);
            this.accountId(model.accountId);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final FastLaunchSnapshotConfiguration.Builder getSnapshotConfiguration() {
            return this.snapshotConfiguration != null ? this.snapshotConfiguration.toBuilder() : null;
        }

        public final void setSnapshotConfiguration(FastLaunchSnapshotConfiguration.BuilderImpl snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration != null ? snapshotConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder snapshotConfiguration(FastLaunchSnapshotConfiguration snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration;
            return this;
        }

        public final Integer getMaxParallelLaunches() {
            return this.maxParallelLaunches;
        }

        public final void setMaxParallelLaunches(Integer maxParallelLaunches) {
            this.maxParallelLaunches = maxParallelLaunches;
        }

        @Override
        @Transient
        public final Builder maxParallelLaunches(Integer maxParallelLaunches) {
            this.maxParallelLaunches = maxParallelLaunches;
            return this;
        }

        public final FastLaunchLaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(FastLaunchLaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        @Transient
        public final Builder launchTemplate(FastLaunchLaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public FastLaunchConfiguration build() {
            return new FastLaunchConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FastLaunchConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder snapshotConfiguration(FastLaunchSnapshotConfiguration var1);

        default public Builder snapshotConfiguration(Consumer<FastLaunchSnapshotConfiguration.Builder> snapshotConfiguration) {
            return this.snapshotConfiguration((FastLaunchSnapshotConfiguration)((FastLaunchSnapshotConfiguration.Builder)FastLaunchSnapshotConfiguration.builder().applyMutation(snapshotConfiguration)).build());
        }

        public Builder maxParallelLaunches(Integer var1);

        public Builder launchTemplate(FastLaunchLaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<FastLaunchLaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((FastLaunchLaunchTemplateSpecification)((FastLaunchLaunchTemplateSpecification.Builder)FastLaunchLaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder accountId(String var1);
    }
}

