/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ImageVersion;
import software.amazon.awssdk.services.imagebuilder.model.ImageVersionListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImagesResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListImagesResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(ListImagesResponse.getter(ListImagesResponse::requestId)).setter(ListImagesResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<List<ImageVersion>> IMAGE_VERSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageVersionList").getter(ListImagesResponse.getter(ListImagesResponse::imageVersionList)).setter(ListImagesResponse.setter(Builder::imageVersionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageVersionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListImagesResponse.getter(ListImagesResponse::nextToken)).setter(ListImagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, IMAGE_VERSION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final String requestIdValue;
    private final List<ImageVersion> imageVersionList;
    private final String nextToken;

    private ListImagesResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.imageVersionList = builder.imageVersionList;
        this.nextToken = builder.nextToken;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final boolean hasImageVersionList() {
        return this.imageVersionList != null && !(this.imageVersionList instanceof SdkAutoConstructList);
    }

    public final List<ImageVersion> imageVersionList() {
        return this.imageVersionList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageVersionList() ? this.imageVersionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagesResponse)) {
            return false;
        }
        ListImagesResponse other = (ListImagesResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && this.hasImageVersionList() == other.hasImageVersionList() && Objects.equals(this.imageVersionList(), other.imageVersionList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListImagesResponse").add("RequestId", (Object)this.requestId()).add("ImageVersionList", this.hasImageVersionList() ? this.imageVersionList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "imageVersionList": {
                return Optional.ofNullable(clazz.cast(this.imageVersionList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImagesResponse, T> g) {
        return obj -> g.apply((ListImagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private List<ImageVersion> imageVersionList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagesResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.imageVersionList(model.imageVersionList);
            this.nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final Collection<ImageVersion.Builder> getImageVersionList() {
            if (this.imageVersionList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageVersionList != null ? (Collection)this.imageVersionList.stream().map(ImageVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageVersionList(Collection<ImageVersion> imageVersionList) {
            this.imageVersionList = ImageVersionListCopier.copy(imageVersionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageVersionList(ImageVersion ... imageVersionList) {
            this.imageVersionList(Arrays.asList(imageVersionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageVersionList(Consumer<ImageVersion.Builder> ... imageVersionList) {
            this.imageVersionList(Stream.of(imageVersionList).map(c -> (ImageVersion)((ImageVersion.Builder)ImageVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImageVersionList(Collection<ImageVersion.BuilderImpl> imageVersionList) {
            this.imageVersionList = ImageVersionListCopier.copyFromBuilder(imageVersionList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListImagesResponse build() {
            return new ListImagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImagesResponse> {
        public Builder requestId(String var1);

        public Builder imageVersionList(Collection<ImageVersion> var1);

        public Builder imageVersionList(ImageVersion ... var1);

        public Builder imageVersionList(Consumer<ImageVersion.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

