/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutImageRecipePolicyRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, PutImageRecipePolicyRequest> {
    private static final SdkField<String> IMAGE_RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageRecipeArn").getter(PutImageRecipePolicyRequest.getter(PutImageRecipePolicyRequest::imageRecipeArn)).setter(PutImageRecipePolicyRequest.setter(Builder::imageRecipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipeArn").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policy").getter(PutImageRecipePolicyRequest.getter(PutImageRecipePolicyRequest::policy)).setter(PutImageRecipePolicyRequest.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_RECIPE_ARN_FIELD, POLICY_FIELD));
    private final String imageRecipeArn;
    private final String policy;

    private PutImageRecipePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.imageRecipeArn = builder.imageRecipeArn;
        this.policy = builder.policy;
    }

    public String imageRecipeArn() {
        return this.imageRecipeArn;
    }

    public String policy() {
        return this.policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutImageRecipePolicyRequest)) {
            return false;
        }
        PutImageRecipePolicyRequest other = (PutImageRecipePolicyRequest)((Object)obj);
        return Objects.equals(this.imageRecipeArn(), other.imageRecipeArn()) && Objects.equals(this.policy(), other.policy());
    }

    public String toString() {
        return ToString.builder((String)"PutImageRecipePolicyRequest").add("ImageRecipeArn", (Object)this.imageRecipeArn()).add("Policy", (Object)this.policy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageRecipeArn": {
                return Optional.ofNullable(clazz.cast(this.imageRecipeArn()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutImageRecipePolicyRequest, T> g) {
        return obj -> g.apply((PutImageRecipePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String imageRecipeArn;
        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutImageRecipePolicyRequest model) {
            super(model);
            this.imageRecipeArn(model.imageRecipeArn);
            this.policy(model.policy);
        }

        public final String getImageRecipeArn() {
            return this.imageRecipeArn;
        }

        @Override
        public final Builder imageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        public final void setImageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutImageRecipePolicyRequest build() {
            return new PutImageRecipePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutImageRecipePolicyRequest> {
        public Builder imageRecipeArn(String var1);

        public Builder policy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

