/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInfrastructureConfigurationResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, CreateInfrastructureConfigurationResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInfrastructureConfigurationResponse.getter(CreateInfrastructureConfigurationResponse::requestId)).setter(CreateInfrastructureConfigurationResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInfrastructureConfigurationResponse.getter(CreateInfrastructureConfigurationResponse::clientToken)).setter(CreateInfrastructureConfigurationResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInfrastructureConfigurationResponse.getter(CreateInfrastructureConfigurationResponse::infrastructureConfigurationArn)).setter(CreateInfrastructureConfigurationResponse.setter(Builder::infrastructureConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfigurationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, CLIENT_TOKEN_FIELD, INFRASTRUCTURE_CONFIGURATION_ARN_FIELD));
    private final String requestIdValue;
    private final String clientToken;
    private final String infrastructureConfigurationArn;

    private CreateInfrastructureConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.clientToken = builder.clientToken;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
    }

    public String requestId() {
        return this.requestIdValue;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String infrastructureConfigurationArn() {
        return this.infrastructureConfigurationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureConfigurationArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInfrastructureConfigurationResponse)) {
            return false;
        }
        CreateInfrastructureConfigurationResponse other = (CreateInfrastructureConfigurationResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.infrastructureConfigurationArn(), other.infrastructureConfigurationArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateInfrastructureConfigurationResponse").add("RequestId", (Object)this.requestId()).add("ClientToken", (Object)this.clientToken()).add("InfrastructureConfigurationArn", (Object)this.infrastructureConfigurationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "infrastructureConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.infrastructureConfigurationArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInfrastructureConfigurationResponse, T> g) {
        return obj -> g.apply((CreateInfrastructureConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String clientToken;
        private String infrastructureConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInfrastructureConfigurationResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.clientToken(model.clientToken);
            this.infrastructureConfigurationArn(model.infrastructureConfigurationArn);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getInfrastructureConfigurationArn() {
            return this.infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        @Override
        public CreateInfrastructureConfigurationResponse build() {
            return new CreateInfrastructureConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInfrastructureConfigurationResponse> {
        public Builder requestId(String var1);

        public Builder clientToken(String var1);

        public Builder infrastructureConfigurationArn(String var1);
    }
}

