/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComponentRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<GetComponentRequest.Builder, GetComponentRequest> {
    private static final SdkField<String> COMPONENT_BUILD_VERSION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetComponentRequest::componentBuildVersionArn))
            .setter(setter(Builder::componentBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("componentBuildVersionArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COMPONENT_BUILD_VERSION_ARN_FIELD));

    private final String componentBuildVersionArn;

    private GetComponentRequest(BuilderImpl builder) {
        super(builder);
        this.componentBuildVersionArn = builder.componentBuildVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the component that you wish to retrieve.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the component that you wish to retrieve.
     */
    public String componentBuildVersionArn() {
        return componentBuildVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(componentBuildVersionArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComponentRequest)) {
            return false;
        }
        GetComponentRequest other = (GetComponentRequest) obj;
        return Objects.equals(componentBuildVersionArn(), other.componentBuildVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetComponentRequest").add("ComponentBuildVersionArn", componentBuildVersionArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentBuildVersionArn":
            return Optional.ofNullable(clazz.cast(componentBuildVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComponentRequest, T> g) {
        return obj -> g.apply((GetComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetComponentRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the component that you wish to retrieve.
         * </p>
         * 
         * @param componentBuildVersionArn
         *        The Amazon Resource Name (ARN) of the component that you wish to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentBuildVersionArn(String componentBuildVersionArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String componentBuildVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComponentRequest model) {
            super(model);
            componentBuildVersionArn(model.componentBuildVersionArn);
        }

        public final String getComponentBuildVersionArn() {
            return componentBuildVersionArn;
        }

        @Override
        public final Builder componentBuildVersionArn(String componentBuildVersionArn) {
            this.componentBuildVersionArn = componentBuildVersionArn;
            return this;
        }

        public final void setComponentBuildVersionArn(String componentBuildVersionArn) {
            this.componentBuildVersionArn = componentBuildVersionArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetComponentRequest build() {
            return new GetComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
