/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.Group;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse;

public class ListGroupsForUserIterable
implements SdkIterable<ListGroupsForUserResponse> {
    private final IamClient client;
    private final ListGroupsForUserRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupsForUserIterable(IamClient client, ListGroupsForUserRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupsForUserResponseFetcher();
    }

    public Iterator<ListGroupsForUserResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Group> groups() {
        Function<ListGroupsForUserResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGroupsForUserResponseFetcher
    implements SyncPageFetcher<ListGroupsForUserResponse> {
        private ListGroupsForUserResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsForUserResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListGroupsForUserResponse nextPage(ListGroupsForUserResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsForUserIterable.this.client.listGroupsForUser(ListGroupsForUserIterable.this.firstRequest);
            }
            return ListGroupsForUserIterable.this.client.listGroupsForUser((ListGroupsForUserRequest)((Object)ListGroupsForUserIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

