/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model._attachedPoliciesListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAttachedUserPoliciesResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListAttachedUserPoliciesResponse> {
    private static final SdkField<List<AttachedPolicy>> ATTACHED_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListAttachedUserPoliciesResponse.getter(ListAttachedUserPoliciesResponse::attachedPolicies)).setter(ListAttachedUserPoliciesResponse.setter(Builder::attachedPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachedPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListAttachedUserPoliciesResponse.getter(ListAttachedUserPoliciesResponse::isTruncated)).setter(ListAttachedUserPoliciesResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAttachedUserPoliciesResponse.getter(ListAttachedUserPoliciesResponse::marker)).setter(ListAttachedUserPoliciesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHED_POLICIES_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private final List<AttachedPolicy> attachedPolicies;
    private final Boolean isTruncated;
    private final String marker;

    private ListAttachedUserPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.attachedPolicies = builder.attachedPolicies;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<AttachedPolicy> attachedPolicies() {
        return this.attachedPolicies;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttachedUserPoliciesResponse)) {
            return false;
        }
        ListAttachedUserPoliciesResponse other = (ListAttachedUserPoliciesResponse)((Object)obj);
        return Objects.equals(this.attachedPolicies(), other.attachedPolicies()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListAttachedUserPoliciesResponse").add("AttachedPolicies", this.attachedPolicies()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachedPolicies": {
                return Optional.ofNullable(clazz.cast(this.attachedPolicies()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAttachedUserPoliciesResponse, T> g) {
        return obj -> g.apply((ListAttachedUserPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<AttachedPolicy> attachedPolicies = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttachedUserPoliciesResponse model) {
            super(model);
            this.attachedPolicies(model.attachedPolicies);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<AttachedPolicy.Builder> getAttachedPolicies() {
            return this.attachedPolicies != null ? (Collection)this.attachedPolicies.stream().map(AttachedPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachedPolicies(Collection<AttachedPolicy> attachedPolicies) {
            this.attachedPolicies = _attachedPoliciesListTypeCopier.copy(attachedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedPolicies(AttachedPolicy ... attachedPolicies) {
            this.attachedPolicies(Arrays.asList(attachedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedPolicies(Consumer<AttachedPolicy.Builder> ... attachedPolicies) {
            this.attachedPolicies(Stream.of(attachedPolicies).map(c -> (AttachedPolicy)((AttachedPolicy.Builder)AttachedPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachedPolicies(Collection<AttachedPolicy.BuilderImpl> attachedPolicies) {
            this.attachedPolicies = _attachedPoliciesListTypeCopier.copyFromBuilder(attachedPolicies);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListAttachedUserPoliciesResponse build() {
            return new ListAttachedUserPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAttachedUserPoliciesResponse> {
        public Builder attachedPolicies(Collection<AttachedPolicy> var1);

        public Builder attachedPolicies(AttachedPolicy ... var1);

        public Builder attachedPolicies(Consumer<AttachedPolicy.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

