/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model._instanceProfileListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstanceProfilesForRoleResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListInstanceProfilesForRoleResponse> {
    private static final SdkField<List<InstanceProfile>> INSTANCE_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListInstanceProfilesForRoleResponse.getter(ListInstanceProfilesForRoleResponse::instanceProfiles)).setter(ListInstanceProfilesForRoleResponse.setter(Builder::instanceProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListInstanceProfilesForRoleResponse.getter(ListInstanceProfilesForRoleResponse::isTruncated)).setter(ListInstanceProfilesForRoleResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListInstanceProfilesForRoleResponse.getter(ListInstanceProfilesForRoleResponse::marker)).setter(ListInstanceProfilesForRoleResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PROFILES_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private final List<InstanceProfile> instanceProfiles;
    private final Boolean isTruncated;
    private final String marker;

    private ListInstanceProfilesForRoleResponse(BuilderImpl builder) {
        super(builder);
        this.instanceProfiles = builder.instanceProfiles;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<InstanceProfile> instanceProfiles() {
        return this.instanceProfiles;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceProfilesForRoleResponse)) {
            return false;
        }
        ListInstanceProfilesForRoleResponse other = (ListInstanceProfilesForRoleResponse)((Object)obj);
        return Objects.equals(this.instanceProfiles(), other.instanceProfiles()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListInstanceProfilesForRoleResponse").add("InstanceProfiles", this.instanceProfiles()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceProfiles": {
                return Optional.ofNullable(clazz.cast(this.instanceProfiles()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstanceProfilesForRoleResponse, T> g) {
        return obj -> g.apply((ListInstanceProfilesForRoleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<InstanceProfile> instanceProfiles = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceProfilesForRoleResponse model) {
            super(model);
            this.instanceProfiles(model.instanceProfiles);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<InstanceProfile.Builder> getInstanceProfiles() {
            return this.instanceProfiles != null ? (Collection)this.instanceProfiles.stream().map(InstanceProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceProfiles(Collection<InstanceProfile> instanceProfiles) {
            this.instanceProfiles = _instanceProfileListTypeCopier.copy(instanceProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(InstanceProfile ... instanceProfiles) {
            this.instanceProfiles(Arrays.asList(instanceProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(Consumer<InstanceProfile.Builder> ... instanceProfiles) {
            this.instanceProfiles(Stream.of(instanceProfiles).map(c -> (InstanceProfile)((InstanceProfile.Builder)InstanceProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceProfiles(Collection<InstanceProfile.BuilderImpl> instanceProfiles) {
            this.instanceProfiles = _instanceProfileListTypeCopier.copyFromBuilder(instanceProfiles);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListInstanceProfilesForRoleResponse build() {
            return new ListInstanceProfilesForRoleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInstanceProfilesForRoleResponse> {
        public Builder instanceProfiles(Collection<InstanceProfile> var1);

        public Builder instanceProfiles(InstanceProfile ... var1);

        public Builder instanceProfiles(Consumer<InstanceProfile.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

