/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SummaryKeyType {
    USERS("Users"),
    USERS_QUOTA("UsersQuota"),
    GROUPS("Groups"),
    GROUPS_QUOTA("GroupsQuota"),
    SERVER_CERTIFICATES("ServerCertificates"),
    SERVER_CERTIFICATES_QUOTA("ServerCertificatesQuota"),
    USER_POLICY_SIZE_QUOTA("UserPolicySizeQuota"),
    GROUP_POLICY_SIZE_QUOTA("GroupPolicySizeQuota"),
    GROUPS_PER_USER_QUOTA("GroupsPerUserQuota"),
    SIGNING_CERTIFICATES_PER_USER_QUOTA("SigningCertificatesPerUserQuota"),
    ACCESS_KEYS_PER_USER_QUOTA("AccessKeysPerUserQuota"),
    MFA_DEVICES("MFADevices"),
    MFA_DEVICES_IN_USE("MFADevicesInUse"),
    ACCOUNT_MFA_ENABLED("AccountMFAEnabled"),
    ACCOUNT_ACCESS_KEYS_PRESENT("AccountAccessKeysPresent"),
    ACCOUNT_SIGNING_CERTIFICATES_PRESENT("AccountSigningCertificatesPresent"),
    ATTACHED_POLICIES_PER_GROUP_QUOTA("AttachedPoliciesPerGroupQuota"),
    ATTACHED_POLICIES_PER_ROLE_QUOTA("AttachedPoliciesPerRoleQuota"),
    ATTACHED_POLICIES_PER_USER_QUOTA("AttachedPoliciesPerUserQuota"),
    POLICIES("Policies"),
    POLICIES_QUOTA("PoliciesQuota"),
    POLICY_SIZE_QUOTA("PolicySizeQuota"),
    POLICY_VERSIONS_IN_USE("PolicyVersionsInUse"),
    POLICY_VERSIONS_IN_USE_QUOTA("PolicyVersionsInUseQuota"),
    VERSIONS_PER_POLICY_QUOTA("VersionsPerPolicyQuota"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SummaryKeyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SummaryKeyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SummaryKeyType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SummaryKeyType> knownValues() {
        return Stream.of(SummaryKeyType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

