/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.EvaluationResult;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse;

public class SimulateCustomPolicyPublisher
implements SdkPublisher<SimulateCustomPolicyResponse> {
    private final IamAsyncClient client;
    private final SimulateCustomPolicyRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SimulateCustomPolicyPublisher(IamAsyncClient client, SimulateCustomPolicyRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SimulateCustomPolicyPublisher(IamAsyncClient client, SimulateCustomPolicyRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SimulateCustomPolicyResponseFetcher();
    }

    public void subscribe(Subscriber<? super SimulateCustomPolicyResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EvaluationResult> evaluationResults() {
        return this.flatMapIterable(response -> response.evaluationResults());
    }

    private class SimulateCustomPolicyResponseFetcher
    implements AsyncPageFetcher<SimulateCustomPolicyResponse> {
        private SimulateCustomPolicyResponseFetcher() {
        }

        public boolean hasNextPage(SimulateCustomPolicyResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<SimulateCustomPolicyResponse> nextPage(SimulateCustomPolicyResponse previousPage) {
            if (previousPage == null) {
                return SimulateCustomPolicyPublisher.this.client.simulateCustomPolicy(SimulateCustomPolicyPublisher.this.firstRequest);
            }
            return SimulateCustomPolicyPublisher.this.client.simulateCustomPolicy((SimulateCustomPolicyRequest)((Object)SimulateCustomPolicyPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

