/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListSamlProviderTagsRequest;
import software.amazon.awssdk.services.iam.model.ListSamlProviderTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListSAMLProviderTagsPublisher
implements SdkPublisher<ListSamlProviderTagsResponse> {
    private final IamAsyncClient client;
    private final ListSamlProviderTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSAMLProviderTagsPublisher(IamAsyncClient client, ListSamlProviderTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSAMLProviderTagsPublisher(IamAsyncClient client, ListSamlProviderTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSamlProviderTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSamlProviderTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Tag> tags() {
        return this.flatMapIterable(response -> response.tags());
    }

    private class ListSamlProviderTagsResponseFetcher
    implements AsyncPageFetcher<ListSamlProviderTagsResponse> {
        private ListSamlProviderTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListSamlProviderTagsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListSamlProviderTagsResponse> nextPage(ListSamlProviderTagsResponse previousPage) {
            if (previousPage == null) {
                return ListSAMLProviderTagsPublisher.this.client.listSAMLProviderTags(ListSAMLProviderTagsPublisher.this.firstRequest);
            }
            return ListSAMLProviderTagsPublisher.this.client.listSAMLProviderTags((ListSamlProviderTagsRequest)((Object)ListSAMLProviderTagsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

