/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListSamlProviderTagsRequest;
import software.amazon.awssdk.services.iam.model.ListSamlProviderTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListSAMLProviderTagsIterable
implements SdkIterable<ListSamlProviderTagsResponse> {
    private final IamClient client;
    private final ListSamlProviderTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSAMLProviderTagsIterable(IamClient client, ListSamlProviderTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSamlProviderTagsResponseFetcher();
    }

    public Iterator<ListSamlProviderTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Tag> tags() {
        Function<ListSamlProviderTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSamlProviderTagsResponseFetcher
    implements SyncPageFetcher<ListSamlProviderTagsResponse> {
        private ListSamlProviderTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListSamlProviderTagsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public ListSamlProviderTagsResponse nextPage(ListSamlProviderTagsResponse previousPage) {
            if (previousPage == null) {
                return ListSAMLProviderTagsIterable.this.client.listSAMLProviderTags(ListSAMLProviderTagsIterable.this.firstRequest);
            }
            return ListSAMLProviderTagsIterable.this.client.listSAMLProviderTags((ListSamlProviderTagsRequest)((Object)ListSAMLProviderTagsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

