/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.MFADevice;
import software.amazon.awssdk.services.iam.model._mfaDeviceListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMfaDevicesResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListMfaDevicesResponse> {
    private static final SdkField<List<MFADevice>> MFA_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListMfaDevicesResponse.getter(ListMfaDevicesResponse::mfaDevices)).setter(ListMfaDevicesResponse.setter(Builder::mfaDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MFADevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MFADevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListMfaDevicesResponse.getter(ListMfaDevicesResponse::isTruncated)).setter(ListMfaDevicesResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMfaDevicesResponse.getter(ListMfaDevicesResponse::marker)).setter(ListMfaDevicesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MFA_DEVICES_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private final List<MFADevice> mfaDevices;
    private final Boolean isTruncated;
    private final String marker;

    private ListMfaDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.mfaDevices = builder.mfaDevices;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<MFADevice> mfaDevices() {
        return this.mfaDevices;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaDevices());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMfaDevicesResponse)) {
            return false;
        }
        ListMfaDevicesResponse other = (ListMfaDevicesResponse)((Object)obj);
        return Objects.equals(this.mfaDevices(), other.mfaDevices()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListMfaDevicesResponse").add("MFADevices", this.mfaDevices()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MFADevices": {
                return Optional.ofNullable(clazz.cast(this.mfaDevices()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMfaDevicesResponse, T> g) {
        return obj -> g.apply((ListMfaDevicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<MFADevice> mfaDevices = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMfaDevicesResponse model) {
            super(model);
            this.mfaDevices(model.mfaDevices);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<MFADevice.Builder> getMfaDevices() {
            return this.mfaDevices != null ? (Collection)this.mfaDevices.stream().map(MFADevice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mfaDevices(Collection<MFADevice> mfaDevices) {
            this.mfaDevices = _mfaDeviceListTypeCopier.copy(mfaDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaDevices(MFADevice ... mfaDevices) {
            this.mfaDevices(Arrays.asList(mfaDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaDevices(Consumer<MFADevice.Builder> ... mfaDevices) {
            this.mfaDevices(Stream.of(mfaDevices).map(c -> (MFADevice)((MFADevice.Builder)MFADevice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMfaDevices(Collection<MFADevice.BuilderImpl> mfaDevices) {
            this.mfaDevices = _mfaDeviceListTypeCopier.copyFromBuilder(mfaDevices);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListMfaDevicesResponse build() {
            return new ListMfaDevicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMfaDevicesResponse> {
        public Builder mfaDevices(Collection<MFADevice> var1);

        public Builder mfaDevices(MFADevice ... var1);

        public Builder mfaDevices(Consumer<MFADevice.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

