/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessKeyLastUsed
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessKeyLastUsed> {
    private static final SdkField<Instant> LAST_USED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AccessKeyLastUsed.getter(AccessKeyLastUsed::lastUsedDate)).setter(AccessKeyLastUsed.setter(Builder::lastUsedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUsedDate").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AccessKeyLastUsed.getter(AccessKeyLastUsed::serviceName)).setter(AccessKeyLastUsed.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AccessKeyLastUsed.getter(AccessKeyLastUsed::region)).setter(AccessKeyLastUsed.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_USED_DATE_FIELD, SERVICE_NAME_FIELD, REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant lastUsedDate;
    private final String serviceName;
    private final String region;

    private AccessKeyLastUsed(BuilderImpl builder) {
        this.lastUsedDate = builder.lastUsedDate;
        this.serviceName = builder.serviceName;
        this.region = builder.region;
    }

    public Instant lastUsedDate() {
        return this.lastUsedDate;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUsedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessKeyLastUsed)) {
            return false;
        }
        AccessKeyLastUsed other = (AccessKeyLastUsed)obj;
        return Objects.equals(this.lastUsedDate(), other.lastUsedDate()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.region(), other.region());
    }

    public String toString() {
        return ToString.builder((String)"AccessKeyLastUsed").add("LastUsedDate", (Object)this.lastUsedDate()).add("ServiceName", (Object)this.serviceName()).add("Region", (Object)this.region()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastUsedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUsedDate()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessKeyLastUsed, T> g) {
        return obj -> g.apply((AccessKeyLastUsed)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant lastUsedDate;
        private String serviceName;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessKeyLastUsed model) {
            this.lastUsedDate(model.lastUsedDate);
            this.serviceName(model.serviceName);
            this.region(model.region);
        }

        public final Instant getLastUsedDate() {
            return this.lastUsedDate;
        }

        @Override
        public final Builder lastUsedDate(Instant lastUsedDate) {
            this.lastUsedDate = lastUsedDate;
            return this;
        }

        public final void setLastUsedDate(Instant lastUsedDate) {
            this.lastUsedDate = lastUsedDate;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public AccessKeyLastUsed build() {
            return new AccessKeyLastUsed(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessKeyLastUsed> {
        public Builder lastUsedDate(Instant var1);

        public Builder serviceName(String var1);

        public Builder region(String var1);
    }
}

