/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iam.model.Policy;

public class ListPoliciesPublisher
implements SdkPublisher<ListPoliciesResponse> {
    private final IamAsyncClient client;
    private final ListPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPoliciesPublisher(IamAsyncClient client, ListPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPoliciesPublisher(IamAsyncClient client, ListPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Policy> policies() {
        Function<ListPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policies() != null) {
                return response.policies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPoliciesResponseFetcher
    implements AsyncPageFetcher<ListPoliciesResponse> {
        private ListPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListPoliciesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListPoliciesResponse> nextPage(ListPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListPoliciesPublisher.this.client.listPolicies(ListPoliciesPublisher.this.firstRequest);
            }
            return ListPoliciesPublisher.this.client.listPolicies((ListPoliciesRequest)((Object)ListPoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

