/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListServerCertificateTagsRequest;
import software.amazon.awssdk.services.iam.model.ListServerCertificateTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListServerCertificateTagsIterable
implements SdkIterable<ListServerCertificateTagsResponse> {
    private final IamClient client;
    private final ListServerCertificateTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServerCertificateTagsIterable(IamClient client, ListServerCertificateTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServerCertificateTagsResponseFetcher();
    }

    public Iterator<ListServerCertificateTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Tag> tags() {
        Function<ListServerCertificateTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServerCertificateTagsResponseFetcher
    implements SyncPageFetcher<ListServerCertificateTagsResponse> {
        private ListServerCertificateTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListServerCertificateTagsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public ListServerCertificateTagsResponse nextPage(ListServerCertificateTagsResponse previousPage) {
            if (previousPage == null) {
                return ListServerCertificateTagsIterable.this.client.listServerCertificateTags(ListServerCertificateTagsIterable.this.firstRequest);
            }
            return ListServerCertificateTagsIterable.this.client.listServerCertificateTags((ListServerCertificateTagsRequest)((Object)ListServerCertificateTagsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

