/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.AccessDetail;
import software.amazon.awssdk.services.iam.model.AccessDetailsCopier;
import software.amazon.awssdk.services.iam.model.ErrorDetails;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.JobStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOrganizationsAccessReportResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetOrganizationsAccessReportResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(GetOrganizationsAccessReportResponse.getter(GetOrganizationsAccessReportResponse::jobStatusAsString)).setter(GetOrganizationsAccessReportResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<Instant> JOB_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("JobCreationDate").getter(GetOrganizationsAccessReportResponse.getter(GetOrganizationsAccessReportResponse::jobCreationDate)).setter(GetOrganizationsAccessReportResponse.setter(Builder::jobCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCreationDate").build()}).build();
    private static final SdkField<Instant> JOB_COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("JobCompletionDate").getter(GetOrganizationsAccessReportResponse.getter(GetOrganizationsAccessReportResponse::jobCompletionDate)).setter(GetOrganizationsAccessReportResponse.setter(Builder::jobCompletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCompletionDate").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_SERVICES_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfServicesAccessible").getter(GetOrganizationsAccessReportResponse.getter(GetOrganizationsAccessReportResponse::numberOfServicesAccessible)).setter(GetOrganizationsAccessReportResponse.setter(Builder::numberOfServicesAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfServicesAccessible").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_SERVICES_NOT_ACCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfServicesNotAccessed").getter(GetOrganizationsAccessReportResponse.getter(GetOrganizationsAccessReportResponse::numberOfServicesNotAccessed)).setter(GetOrganizationsAccessReportResponse.setter(Builder::numberOfServicesNotAccessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfServicesNotAccessed").build()}).build();
    private static final SdkField<List<AccessDetail>> ACCESS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessDetails").getter(GetOrganizationsAccessReportResponse.getter(GetOrganizationsAccessReportResponse::accessDetails)).setter(GetOrganizationsAccessReportResponse.setter(Builder::accessDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(GetOrganizationsAccessReportResponse.getter(GetOrganizationsAccessReportResponse::isTruncated)).setter(GetOrganizationsAccessReportResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(GetOrganizationsAccessReportResponse.getter(GetOrganizationsAccessReportResponse::marker)).setter(GetOrganizationsAccessReportResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorDetails").getter(GetOrganizationsAccessReportResponse.getter(GetOrganizationsAccessReportResponse::errorDetails)).setter(GetOrganizationsAccessReportResponse.setter(Builder::errorDetails)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, JOB_CREATION_DATE_FIELD, JOB_COMPLETION_DATE_FIELD, NUMBER_OF_SERVICES_ACCESSIBLE_FIELD, NUMBER_OF_SERVICES_NOT_ACCESSED_FIELD, ACCESS_DETAILS_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD, ERROR_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOrganizationsAccessReportResponse.memberNameToFieldInitializer();
    private final String jobStatus;
    private final Instant jobCreationDate;
    private final Instant jobCompletionDate;
    private final Integer numberOfServicesAccessible;
    private final Integer numberOfServicesNotAccessed;
    private final List<AccessDetail> accessDetails;
    private final Boolean isTruncated;
    private final String marker;
    private final ErrorDetails errorDetails;

    private GetOrganizationsAccessReportResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.jobCreationDate = builder.jobCreationDate;
        this.jobCompletionDate = builder.jobCompletionDate;
        this.numberOfServicesAccessible = builder.numberOfServicesAccessible;
        this.numberOfServicesNotAccessed = builder.numberOfServicesNotAccessed;
        this.accessDetails = builder.accessDetails;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
        this.errorDetails = builder.errorDetails;
    }

    public final JobStatusType jobStatus() {
        return JobStatusType.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final Instant jobCreationDate() {
        return this.jobCreationDate;
    }

    public final Instant jobCompletionDate() {
        return this.jobCompletionDate;
    }

    public final Integer numberOfServicesAccessible() {
        return this.numberOfServicesAccessible;
    }

    public final Integer numberOfServicesNotAccessed() {
        return this.numberOfServicesNotAccessed;
    }

    public final boolean hasAccessDetails() {
        return this.accessDetails != null && !(this.accessDetails instanceof SdkAutoConstructList);
    }

    public final List<AccessDetail> accessDetails() {
        return this.accessDetails;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String marker() {
        return this.marker;
    }

    public final ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobCompletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfServicesAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfServicesNotAccessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessDetails() ? this.accessDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationsAccessReportResponse)) {
            return false;
        }
        GetOrganizationsAccessReportResponse other = (GetOrganizationsAccessReportResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.jobCreationDate(), other.jobCreationDate()) && Objects.equals(this.jobCompletionDate(), other.jobCompletionDate()) && Objects.equals(this.numberOfServicesAccessible(), other.numberOfServicesAccessible()) && Objects.equals(this.numberOfServicesNotAccessed(), other.numberOfServicesNotAccessed()) && this.hasAccessDetails() == other.hasAccessDetails() && Objects.equals(this.accessDetails(), other.accessDetails()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.errorDetails(), other.errorDetails());
    }

    public final String toString() {
        return ToString.builder((String)"GetOrganizationsAccessReportResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("JobCreationDate", (Object)this.jobCreationDate()).add("JobCompletionDate", (Object)this.jobCompletionDate()).add("NumberOfServicesAccessible", (Object)this.numberOfServicesAccessible()).add("NumberOfServicesNotAccessed", (Object)this.numberOfServicesNotAccessed()).add("AccessDetails", this.hasAccessDetails() ? this.accessDetails() : null).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).add("ErrorDetails", (Object)this.errorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "JobCreationDate": {
                return Optional.ofNullable(clazz.cast(this.jobCreationDate()));
            }
            case "JobCompletionDate": {
                return Optional.ofNullable(clazz.cast(this.jobCompletionDate()));
            }
            case "NumberOfServicesAccessible": {
                return Optional.ofNullable(clazz.cast(this.numberOfServicesAccessible()));
            }
            case "NumberOfServicesNotAccessed": {
                return Optional.ofNullable(clazz.cast(this.numberOfServicesNotAccessed()));
            }
            case "AccessDetails": {
                return Optional.ofNullable(clazz.cast(this.accessDetails()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("JobCreationDate", JOB_CREATION_DATE_FIELD);
        map.put("JobCompletionDate", JOB_COMPLETION_DATE_FIELD);
        map.put("NumberOfServicesAccessible", NUMBER_OF_SERVICES_ACCESSIBLE_FIELD);
        map.put("NumberOfServicesNotAccessed", NUMBER_OF_SERVICES_NOT_ACCESSED_FIELD);
        map.put("AccessDetails", ACCESS_DETAILS_FIELD);
        map.put("IsTruncated", IS_TRUNCATED_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationsAccessReportResponse, T> g) {
        return obj -> g.apply((GetOrganizationsAccessReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private Instant jobCreationDate;
        private Instant jobCompletionDate;
        private Integer numberOfServicesAccessible;
        private Integer numberOfServicesNotAccessed;
        private List<AccessDetail> accessDetails = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;
        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationsAccessReportResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.jobCreationDate(model.jobCreationDate);
            this.jobCompletionDate(model.jobCompletionDate);
            this.numberOfServicesAccessible(model.numberOfServicesAccessible);
            this.numberOfServicesNotAccessed(model.numberOfServicesNotAccessed);
            this.accessDetails(model.accessDetails);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
            this.errorDetails(model.errorDetails);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatusType jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getJobCreationDate() {
            return this.jobCreationDate;
        }

        public final void setJobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
        }

        @Override
        public final Builder jobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
            return this;
        }

        public final Instant getJobCompletionDate() {
            return this.jobCompletionDate;
        }

        public final void setJobCompletionDate(Instant jobCompletionDate) {
            this.jobCompletionDate = jobCompletionDate;
        }

        @Override
        public final Builder jobCompletionDate(Instant jobCompletionDate) {
            this.jobCompletionDate = jobCompletionDate;
            return this;
        }

        public final Integer getNumberOfServicesAccessible() {
            return this.numberOfServicesAccessible;
        }

        public final void setNumberOfServicesAccessible(Integer numberOfServicesAccessible) {
            this.numberOfServicesAccessible = numberOfServicesAccessible;
        }

        @Override
        public final Builder numberOfServicesAccessible(Integer numberOfServicesAccessible) {
            this.numberOfServicesAccessible = numberOfServicesAccessible;
            return this;
        }

        public final Integer getNumberOfServicesNotAccessed() {
            return this.numberOfServicesNotAccessed;
        }

        public final void setNumberOfServicesNotAccessed(Integer numberOfServicesNotAccessed) {
            this.numberOfServicesNotAccessed = numberOfServicesNotAccessed;
        }

        @Override
        public final Builder numberOfServicesNotAccessed(Integer numberOfServicesNotAccessed) {
            this.numberOfServicesNotAccessed = numberOfServicesNotAccessed;
            return this;
        }

        public final List<AccessDetail.Builder> getAccessDetails() {
            List<AccessDetail.Builder> result = AccessDetailsCopier.copyToBuilder(this.accessDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessDetails(Collection<AccessDetail.BuilderImpl> accessDetails) {
            this.accessDetails = AccessDetailsCopier.copyFromBuilder(accessDetails);
        }

        @Override
        public final Builder accessDetails(Collection<AccessDetail> accessDetails) {
            this.accessDetails = AccessDetailsCopier.copy(accessDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessDetails(AccessDetail ... accessDetails) {
            this.accessDetails(Arrays.asList(accessDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessDetails(Consumer<AccessDetail.Builder> ... accessDetails) {
            this.accessDetails(Stream.of(accessDetails).map(c -> (AccessDetail)((AccessDetail.Builder)AccessDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        @Override
        public GetOrganizationsAccessReportResponse build() {
            return new GetOrganizationsAccessReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOrganizationsAccessReportResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatusType var1);

        public Builder jobCreationDate(Instant var1);

        public Builder jobCompletionDate(Instant var1);

        public Builder numberOfServicesAccessible(Integer var1);

        public Builder numberOfServicesNotAccessed(Integer var1);

        public Builder accessDetails(Collection<AccessDetail> var1);

        public Builder accessDetails(AccessDetail ... var1);

        public Builder accessDetails(Consumer<AccessDetail.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);

        public Builder errorDetails(ErrorDetails var1);

        default public Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return this.errorDetails((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(errorDetails)).build());
        }
    }
}

