/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListOpenIDConnectProviderTagsPublisher
implements SdkPublisher<ListOpenIdConnectProviderTagsResponse> {
    private final IamAsyncClient client;
    private final ListOpenIdConnectProviderTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOpenIDConnectProviderTagsPublisher(IamAsyncClient client, ListOpenIdConnectProviderTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOpenIDConnectProviderTagsPublisher(IamAsyncClient client, ListOpenIdConnectProviderTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOpenIdConnectProviderTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOpenIdConnectProviderTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Tag> tags() {
        Function<ListOpenIdConnectProviderTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOpenIdConnectProviderTagsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOpenIdConnectProviderTagsResponseFetcher
    implements AsyncPageFetcher<ListOpenIdConnectProviderTagsResponse> {
        private ListOpenIdConnectProviderTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListOpenIdConnectProviderTagsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListOpenIdConnectProviderTagsResponse> nextPage(ListOpenIdConnectProviderTagsResponse previousPage) {
            if (previousPage == null) {
                return ListOpenIDConnectProviderTagsPublisher.this.client.listOpenIDConnectProviderTags(ListOpenIDConnectProviderTagsPublisher.this.firstRequest);
            }
            return ListOpenIDConnectProviderTagsPublisher.this.client.listOpenIDConnectProviderTags((ListOpenIdConnectProviderTagsRequest)((Object)ListOpenIDConnectProviderTagsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

