/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.ServerCertificateMetadata;
import software.amazon.awssdk.services.iam.model._serverCertificateMetadataListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServerCertificatesResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListServerCertificatesResponse> {
    private static final SdkField<List<ServerCertificateMetadata>> SERVER_CERTIFICATE_METADATA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServerCertificateMetadataList").getter(ListServerCertificatesResponse.getter(ListServerCertificatesResponse::serverCertificateMetadataList)).setter(ListServerCertificatesResponse.setter(Builder::serverCertificateMetadataList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateMetadataList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerCertificateMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListServerCertificatesResponse.getter(ListServerCertificatesResponse::isTruncated)).setter(ListServerCertificatesResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListServerCertificatesResponse.getter(ListServerCertificatesResponse::marker)).setter(ListServerCertificatesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_CERTIFICATE_METADATA_LIST_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServerCertificatesResponse.memberNameToFieldInitializer();
    private final List<ServerCertificateMetadata> serverCertificateMetadataList;
    private final Boolean isTruncated;
    private final String marker;

    private ListServerCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.serverCertificateMetadataList = builder.serverCertificateMetadataList;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public final boolean hasServerCertificateMetadataList() {
        return this.serverCertificateMetadataList != null && !(this.serverCertificateMetadataList instanceof SdkAutoConstructList);
    }

    public final List<ServerCertificateMetadata> serverCertificateMetadataList() {
        return this.serverCertificateMetadataList;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServerCertificateMetadataList() ? this.serverCertificateMetadataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServerCertificatesResponse)) {
            return false;
        }
        ListServerCertificatesResponse other = (ListServerCertificatesResponse)((Object)obj);
        return this.hasServerCertificateMetadataList() == other.hasServerCertificateMetadataList() && Objects.equals(this.serverCertificateMetadataList(), other.serverCertificateMetadataList()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListServerCertificatesResponse").add("ServerCertificateMetadataList", this.hasServerCertificateMetadataList() ? this.serverCertificateMetadataList() : null).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerCertificateMetadataList": {
                return Optional.ofNullable(clazz.cast(this.serverCertificateMetadataList()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServerCertificateMetadataList", SERVER_CERTIFICATE_METADATA_LIST_FIELD);
        map.put("IsTruncated", IS_TRUNCATED_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServerCertificatesResponse, T> g) {
        return obj -> g.apply((ListServerCertificatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<ServerCertificateMetadata> serverCertificateMetadataList = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServerCertificatesResponse model) {
            super(model);
            this.serverCertificateMetadataList(model.serverCertificateMetadataList);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final List<ServerCertificateMetadata.Builder> getServerCertificateMetadataList() {
            List<ServerCertificateMetadata.Builder> result = _serverCertificateMetadataListTypeCopier.copyToBuilder(this.serverCertificateMetadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerCertificateMetadataList(Collection<ServerCertificateMetadata.BuilderImpl> serverCertificateMetadataList) {
            this.serverCertificateMetadataList = _serverCertificateMetadataListTypeCopier.copyFromBuilder(serverCertificateMetadataList);
        }

        @Override
        public final Builder serverCertificateMetadataList(Collection<ServerCertificateMetadata> serverCertificateMetadataList) {
            this.serverCertificateMetadataList = _serverCertificateMetadataListTypeCopier.copy(serverCertificateMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificateMetadataList(ServerCertificateMetadata ... serverCertificateMetadataList) {
            this.serverCertificateMetadataList(Arrays.asList(serverCertificateMetadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificateMetadataList(Consumer<ServerCertificateMetadata.Builder> ... serverCertificateMetadataList) {
            this.serverCertificateMetadataList(Stream.of(serverCertificateMetadataList).map(c -> (ServerCertificateMetadata)((ServerCertificateMetadata.Builder)ServerCertificateMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListServerCertificatesResponse build() {
            return new ListServerCertificatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServerCertificatesResponse> {
        public Builder serverCertificateMetadataList(Collection<ServerCertificateMetadata> var1);

        public Builder serverCertificateMetadataList(ServerCertificateMetadata ... var1);

        public Builder serverCertificateMetadataList(Consumer<ServerCertificateMetadata.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

