/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse;
import software.amazon.awssdk.services.iam.model.ServerCertificateMetadata;

public class ListServerCertificatesPublisher
implements SdkPublisher<ListServerCertificatesResponse> {
    private final IamAsyncClient client;
    private final ListServerCertificatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServerCertificatesPublisher(IamAsyncClient client, ListServerCertificatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServerCertificatesPublisher(IamAsyncClient client, ListServerCertificatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServerCertificatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServerCertificatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServerCertificateMetadata> serverCertificateMetadataList() {
        Function<ListServerCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serverCertificateMetadataList() != null) {
                return response.serverCertificateMetadataList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServerCertificatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListServerCertificatesPublisher resume(ListServerCertificatesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListServerCertificatesPublisher(this.client, (ListServerCertificatesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListServerCertificatesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListServerCertificatesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListServerCertificatesResponseFetcher
    implements AsyncPageFetcher<ListServerCertificatesResponse> {
        private ListServerCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListServerCertificatesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListServerCertificatesResponse> nextPage(ListServerCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListServerCertificatesPublisher.this.client.listServerCertificates(ListServerCertificatesPublisher.this.firstRequest);
            }
            return ListServerCertificatesPublisher.this.client.listServerCertificates((ListServerCertificatesRequest)((Object)ListServerCertificatesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

