/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.PolicySourceType;
import software.amazon.awssdk.services.iam.model.Position;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Statement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Statement> {
    private static final SdkField<String> SOURCE_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Statement.getter(Statement::sourcePolicyId)).setter(Statement.setter(Builder::sourcePolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePolicyId").build()}).build();
    private static final SdkField<String> SOURCE_POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Statement.getter(Statement::sourcePolicyTypeAsString)).setter(Statement.setter(Builder::sourcePolicyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePolicyType").build()}).build();
    private static final SdkField<Position> START_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Statement.getter(Statement::startPosition)).setter(Statement.setter(Builder::startPosition)).constructor(Position::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartPosition").build()}).build();
    private static final SdkField<Position> END_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Statement.getter(Statement::endPosition)).setter(Statement.setter(Builder::endPosition)).constructor(Position::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndPosition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_POLICY_ID_FIELD, SOURCE_POLICY_TYPE_FIELD, START_POSITION_FIELD, END_POSITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourcePolicyId;
    private final String sourcePolicyType;
    private final Position startPosition;
    private final Position endPosition;

    private Statement(BuilderImpl builder) {
        this.sourcePolicyId = builder.sourcePolicyId;
        this.sourcePolicyType = builder.sourcePolicyType;
        this.startPosition = builder.startPosition;
        this.endPosition = builder.endPosition;
    }

    public String sourcePolicyId() {
        return this.sourcePolicyId;
    }

    public PolicySourceType sourcePolicyType() {
        return PolicySourceType.fromValue(this.sourcePolicyType);
    }

    public String sourcePolicyTypeAsString() {
        return this.sourcePolicyType;
    }

    public Position startPosition() {
        return this.startPosition;
    }

    public Position endPosition() {
        return this.endPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePolicyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.endPosition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement other = (Statement)obj;
        return Objects.equals(this.sourcePolicyId(), other.sourcePolicyId()) && Objects.equals(this.sourcePolicyTypeAsString(), other.sourcePolicyTypeAsString()) && Objects.equals(this.startPosition(), other.startPosition()) && Objects.equals(this.endPosition(), other.endPosition());
    }

    public String toString() {
        return ToString.builder((String)"Statement").add("SourcePolicyId", (Object)this.sourcePolicyId()).add("SourcePolicyType", (Object)this.sourcePolicyTypeAsString()).add("StartPosition", (Object)this.startPosition()).add("EndPosition", (Object)this.endPosition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourcePolicyId": {
                return Optional.ofNullable(clazz.cast(this.sourcePolicyId()));
            }
            case "SourcePolicyType": {
                return Optional.ofNullable(clazz.cast(this.sourcePolicyTypeAsString()));
            }
            case "StartPosition": {
                return Optional.ofNullable(clazz.cast(this.startPosition()));
            }
            case "EndPosition": {
                return Optional.ofNullable(clazz.cast(this.endPosition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Statement, T> g) {
        return obj -> g.apply((Statement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourcePolicyId;
        private String sourcePolicyType;
        private Position startPosition;
        private Position endPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(Statement model) {
            this.sourcePolicyId(model.sourcePolicyId);
            this.sourcePolicyType(model.sourcePolicyType);
            this.startPosition(model.startPosition);
            this.endPosition(model.endPosition);
        }

        public final String getSourcePolicyId() {
            return this.sourcePolicyId;
        }

        @Override
        public final Builder sourcePolicyId(String sourcePolicyId) {
            this.sourcePolicyId = sourcePolicyId;
            return this;
        }

        public final void setSourcePolicyId(String sourcePolicyId) {
            this.sourcePolicyId = sourcePolicyId;
        }

        public final String getSourcePolicyTypeAsString() {
            return this.sourcePolicyType;
        }

        @Override
        public final Builder sourcePolicyType(String sourcePolicyType) {
            this.sourcePolicyType = sourcePolicyType;
            return this;
        }

        @Override
        public final Builder sourcePolicyType(PolicySourceType sourcePolicyType) {
            this.sourcePolicyType(sourcePolicyType.toString());
            return this;
        }

        public final void setSourcePolicyType(String sourcePolicyType) {
            this.sourcePolicyType = sourcePolicyType;
        }

        public final Position.Builder getStartPosition() {
            return this.startPosition != null ? this.startPosition.toBuilder() : null;
        }

        @Override
        public final Builder startPosition(Position startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public final void setStartPosition(Position.BuilderImpl startPosition) {
            this.startPosition = startPosition != null ? startPosition.build() : null;
        }

        public final Position.Builder getEndPosition() {
            return this.endPosition != null ? this.endPosition.toBuilder() : null;
        }

        @Override
        public final Builder endPosition(Position endPosition) {
            this.endPosition = endPosition;
            return this;
        }

        public final void setEndPosition(Position.BuilderImpl endPosition) {
            this.endPosition = endPosition != null ? endPosition.build() : null;
        }

        public Statement build() {
            return new Statement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Statement> {
        public Builder sourcePolicyId(String var1);

        public Builder sourcePolicyType(String var1);

        public Builder sourcePolicyType(PolicySourceType var1);

        public Builder startPosition(Position var1);

        default public Builder startPosition(Consumer<Position.Builder> startPosition) {
            return this.startPosition((Position)((Position.Builder)Position.builder().applyMutation(startPosition)).build());
        }

        public Builder endPosition(Position var1);

        default public Builder endPosition(Consumer<Position.Builder> endPosition) {
            return this.endPosition((Position)((Position.Builder)Position.builder().applyMutation(endPosition)).build());
        }
    }
}

