/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.Group;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse;

public class ListGroupsForUserPublisher
implements SdkPublisher<ListGroupsForUserResponse> {
    private final IamAsyncClient client;
    private final ListGroupsForUserRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupsForUserPublisher(IamAsyncClient client, ListGroupsForUserRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupsForUserPublisher(IamAsyncClient client, ListGroupsForUserRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupsForUserResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupsForUserResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Group> groups() {
        Function<ListGroupsForUserResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGroupsForUserResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListGroupsForUserPublisher resume(ListGroupsForUserResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListGroupsForUserPublisher(this.client, (ListGroupsForUserRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListGroupsForUserPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListGroupsForUserResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListGroupsForUserResponseFetcher
    implements AsyncPageFetcher<ListGroupsForUserResponse> {
        private ListGroupsForUserResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsForUserResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListGroupsForUserResponse> nextPage(ListGroupsForUserResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsForUserPublisher.this.client.listGroupsForUser(ListGroupsForUserPublisher.this.firstRequest);
            }
            return ListGroupsForUserPublisher.this.client.listGroupsForUser((ListGroupsForUserRequest)((Object)ListGroupsForUserPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

