/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.GetGroupRequest;
import software.amazon.awssdk.services.iam.model.GetGroupResponse;
import software.amazon.awssdk.services.iam.model.User;

public class GetGroupPublisher
implements SdkPublisher<GetGroupResponse> {
    private final IamAsyncClient client;
    private final GetGroupRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetGroupPublisher(IamAsyncClient client, GetGroupRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetGroupPublisher(IamAsyncClient client, GetGroupRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetGroupResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetGroupResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<User> users() {
        Function<GetGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.users() != null) {
                return response.users().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetGroupResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final GetGroupPublisher resume(GetGroupResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetGroupPublisher(this.client, (GetGroupRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new GetGroupPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetGroupResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetGroupResponseFetcher
    implements AsyncPageFetcher<GetGroupResponse> {
        private GetGroupResponseFetcher() {
        }

        public boolean hasNextPage(GetGroupResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<GetGroupResponse> nextPage(GetGroupResponse previousPage) {
            if (previousPage == null) {
                return GetGroupPublisher.this.client.getGroup(GetGroupPublisher.this.firstRequest);
            }
            return GetGroupPublisher.this.client.getGroup((GetGroupRequest)((Object)GetGroupPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

