/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse;

public class ListInstanceProfilesPublisher
implements SdkPublisher<ListInstanceProfilesResponse> {
    private final IamAsyncClient client;
    private final ListInstanceProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstanceProfilesPublisher(IamAsyncClient client, ListInstanceProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstanceProfilesPublisher(IamAsyncClient client, ListInstanceProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstanceProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstanceProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceProfile> instanceProfiles() {
        Function<ListInstanceProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceProfiles() != null) {
                return response.instanceProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInstanceProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListInstanceProfilesPublisher resume(ListInstanceProfilesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInstanceProfilesPublisher(this.client, (ListInstanceProfilesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListInstanceProfilesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListInstanceProfilesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListInstanceProfilesResponseFetcher
    implements AsyncPageFetcher<ListInstanceProfilesResponse> {
        private ListInstanceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceProfilesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListInstanceProfilesResponse> nextPage(ListInstanceProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceProfilesPublisher.this.client.listInstanceProfiles(ListInstanceProfilesPublisher.this.firstRequest);
            }
            return ListInstanceProfilesPublisher.this.client.listInstanceProfiles((ListInstanceProfilesRequest)((Object)ListInstanceProfilesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

