/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.FeatureType;
import software.amazon.awssdk.services.iam.model.FeaturesListTypeCopier;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrganizationsFeaturesResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListOrganizationsFeaturesResponse> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(ListOrganizationsFeaturesResponse.getter(ListOrganizationsFeaturesResponse::organizationId)).setter(ListOrganizationsFeaturesResponse.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<List<String>> ENABLED_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledFeatures").getter(ListOrganizationsFeaturesResponse.getter(ListOrganizationsFeaturesResponse::enabledFeaturesAsStrings)).setter(ListOrganizationsFeaturesResponse.setter(Builder::enabledFeaturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, ENABLED_FEATURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OrganizationId", ORGANIZATION_ID_FIELD);
            this.put("EnabledFeatures", ENABLED_FEATURES_FIELD);
        }
    });
    private final String organizationId;
    private final List<String> enabledFeatures;

    private ListOrganizationsFeaturesResponse(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.enabledFeatures = builder.enabledFeatures;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final List<FeatureType> enabledFeatures() {
        return FeaturesListTypeCopier.copyStringToEnum(this.enabledFeatures);
    }

    public final boolean hasEnabledFeatures() {
        return this.enabledFeatures != null && !(this.enabledFeatures instanceof SdkAutoConstructList);
    }

    public final List<String> enabledFeaturesAsStrings() {
        return this.enabledFeatures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledFeatures() ? this.enabledFeaturesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationsFeaturesResponse)) {
            return false;
        }
        ListOrganizationsFeaturesResponse other = (ListOrganizationsFeaturesResponse)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && this.hasEnabledFeatures() == other.hasEnabledFeatures() && Objects.equals(this.enabledFeaturesAsStrings(), other.enabledFeaturesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListOrganizationsFeaturesResponse").add("OrganizationId", (Object)this.organizationId()).add("EnabledFeatures", this.hasEnabledFeatures() ? this.enabledFeaturesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "EnabledFeatures": {
                return Optional.ofNullable(clazz.cast(this.enabledFeaturesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationsFeaturesResponse, T> g) {
        return obj -> g.apply((ListOrganizationsFeaturesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private String organizationId;
        private List<String> enabledFeatures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationsFeaturesResponse model) {
            super(model);
            this.organizationId(model.organizationId);
            this.enabledFeaturesWithStrings(model.enabledFeatures);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final Collection<String> getEnabledFeatures() {
            if (this.enabledFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledFeatures;
        }

        public final void setEnabledFeatures(Collection<String> enabledFeatures) {
            this.enabledFeatures = FeaturesListTypeCopier.copy(enabledFeatures);
        }

        @Override
        public final Builder enabledFeaturesWithStrings(Collection<String> enabledFeatures) {
            this.enabledFeatures = FeaturesListTypeCopier.copy(enabledFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledFeaturesWithStrings(String ... enabledFeatures) {
            this.enabledFeaturesWithStrings(Arrays.asList(enabledFeatures));
            return this;
        }

        @Override
        public final Builder enabledFeatures(Collection<FeatureType> enabledFeatures) {
            this.enabledFeatures = FeaturesListTypeCopier.copyEnumToString(enabledFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledFeatures(FeatureType ... enabledFeatures) {
            this.enabledFeatures(Arrays.asList(enabledFeatures));
            return this;
        }

        @Override
        public ListOrganizationsFeaturesResponse build() {
            return new ListOrganizationsFeaturesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrganizationsFeaturesResponse> {
        public Builder organizationId(String var1);

        public Builder enabledFeaturesWithStrings(Collection<String> var1);

        public Builder enabledFeaturesWithStrings(String ... var1);

        public Builder enabledFeatures(Collection<FeatureType> var1);

        public Builder enabledFeatures(FeatureType ... var1);
    }
}

