/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesResponse;

public class ListUserPoliciesIterable
implements SdkIterable<ListUserPoliciesResponse> {
    private final IamClient client;
    private final ListUserPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUserPoliciesIterable(IamClient client, ListUserPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUserPoliciesResponseFetcher();
    }

    public Iterator<ListUserPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> policyNames() {
        Function<ListUserPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyNames() != null) {
                return response.policyNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUserPoliciesResponseFetcher
    implements SyncPageFetcher<ListUserPoliciesResponse> {
        private ListUserPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListUserPoliciesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public ListUserPoliciesResponse nextPage(ListUserPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListUserPoliciesIterable.this.client.listUserPolicies(ListUserPoliciesIterable.this.firstRequest);
            }
            return ListUserPoliciesIterable.this.client.listUserPolicies((ListUserPoliciesRequest)((Object)ListUserPoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

