/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.AccessKeyMetadata;
import software.amazon.awssdk.services.iam.model.ListAccessKeysRequest;
import software.amazon.awssdk.services.iam.model.ListAccessKeysResponse;

public class ListAccessKeysIterable
implements SdkIterable<ListAccessKeysResponse> {
    private final IamClient client;
    private final ListAccessKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessKeysIterable(IamClient client, ListAccessKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessKeysResponseFetcher();
    }

    public Iterator<ListAccessKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessKeyMetadata> accessKeyMetadata() {
        Function<ListAccessKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessKeyMetadata() != null) {
                return response.accessKeyMetadata().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccessKeysResponseFetcher
    implements SyncPageFetcher<ListAccessKeysResponse> {
        private ListAccessKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessKeysResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListAccessKeysResponse nextPage(ListAccessKeysResponse previousPage) {
            if (previousPage == null) {
                return ListAccessKeysIterable.this.client.listAccessKeys(ListAccessKeysIterable.this.firstRequest);
            }
            return ListAccessKeysIterable.this.client.listAccessKeys((ListAccessKeysRequest)((Object)ListAccessKeysIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

