/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListUserTagsRequest;
import software.amazon.awssdk.services.iam.model.ListUserTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListUserTagsIterable
implements SdkIterable<ListUserTagsResponse> {
    private final IamClient client;
    private final ListUserTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUserTagsIterable(IamClient client, ListUserTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUserTagsResponseFetcher();
    }

    public Iterator<ListUserTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Tag> tags() {
        Function<ListUserTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUserTagsResponseFetcher
    implements SyncPageFetcher<ListUserTagsResponse> {
        private ListUserTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserTagsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListUserTagsResponse nextPage(ListUserTagsResponse previousPage) {
            if (previousPage == null) {
                return ListUserTagsIterable.this.client.listUserTags(ListUserTagsIterable.this.firstRequest);
            }
            return ListUserTagsIterable.this.client.listUserTags((ListUserTagsRequest)((Object)ListUserTagsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

